/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.similarityfunction;

import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.AbstractIndexBasedSimilarityFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.NormalizedSimilarityFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.SimilarityFunction;
import de.lmu.ifi.dbs.elki.index.Index;
import de.lmu.ifi.dbs.elki.index.preprocessed.snn.SharedNearestNeighborIndex;
import de.lmu.ifi.dbs.elki.index.preprocessed.snn.SharedNearestNeighborPreprocessor;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;

public class FractionalSharedNearestNeighborSimilarityFunction<O>
extends AbstractIndexBasedSimilarityFunction<O, SharedNearestNeighborIndex.Factory<O>>
implements NormalizedSimilarityFunction<O> {
    public FractionalSharedNearestNeighborSimilarityFunction(SharedNearestNeighborIndex.Factory<O> indexFactory) {
        super(indexFactory);
    }

    @Override
    public <T extends O> Instance<T> instantiate(Relation<T> database) {
        Index indexi = ((SharedNearestNeighborIndex.Factory)this.indexFactory).instantiate((Relation)database);
        return new Instance<T>(database, indexi, this);
    }

    public static class Parameterizer<O>
    extends AbstractIndexBasedSimilarityFunction.Parameterizer<SharedNearestNeighborIndex.Factory<O>> {
        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            this.configIndexFactory(config, SharedNearestNeighborIndex.Factory.class, SharedNearestNeighborPreprocessor.Factory.class);
        }

        @Override
        protected FractionalSharedNearestNeighborSimilarityFunction<O> makeInstance() {
            return new FractionalSharedNearestNeighborSimilarityFunction((SharedNearestNeighborIndex.Factory)this.factory);
        }
    }

    public static class Instance<T>
    extends AbstractIndexBasedSimilarityFunction.Instance<T, SharedNearestNeighborIndex<T>> {
        private FractionalSharedNearestNeighborSimilarityFunction<? super T> similarityFunction;

        public Instance(Relation<T> database, SharedNearestNeighborIndex<T> preprocessor, FractionalSharedNearestNeighborSimilarityFunction<? super T> similarityFunction) {
            super(database, preprocessor);
            this.similarityFunction = similarityFunction;
        }

        protected static int countSharedNeighbors(DBIDs neighbors1, DBIDs neighbors2) {
            int intersection = 0;
            DBIDIter iter1 = neighbors1.iter();
            DBIDIter iter2 = neighbors2.iter();
            while (iter1.valid() && iter2.valid()) {
                int comp = DBIDUtil.compare(iter1, iter2);
                if (comp == 0) {
                    ++intersection;
                    iter1.advance();
                    iter2.advance();
                    continue;
                }
                if (comp < 0) {
                    iter1.advance();
                    continue;
                }
                iter2.advance();
            }
            return intersection;
        }

        @Override
        public double similarity(DBIDRef id1, DBIDRef id2) {
            ArrayDBIDs neighbors1 = ((SharedNearestNeighborIndex)this.index).getNearestNeighborSet(id1);
            ArrayDBIDs neighbors2 = ((SharedNearestNeighborIndex)this.index).getNearestNeighborSet(id2);
            int intersection = Instance.countSharedNeighbors(neighbors1, neighbors2);
            return (double)intersection / (double)((SharedNearestNeighborIndex)this.index).getNumberOfNeighbors();
        }

        @Override
        public SimilarityFunction<? super T> getSimilarityFunction() {
            return this.similarityFunction;
        }
    }
}

