/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.similarityfunction;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.database.query.distance.SpatialPrimitiveDistanceSimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.PrimitiveSimilarityFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="M.-M. Deza, E. Deza", title="Dictionary of distances", booktitle="Dictionary of distances", url="https://doi.org/10.1007/978-3-642-00234-2", bibkey="doi:10.1007/978-3-642-00234-2")
@Alias(value={"de.lmu.ifi.dbs.elki.distance.distancefunction.Kulczynski1DistanceFunction"})
public class Kulczynski1SimilarityFunction
extends AbstractNumberVectorDistanceFunction
implements SpatialPrimitiveDistanceFunction<NumberVector>,
PrimitiveSimilarityFunction<NumberVector> {
    public static final Kulczynski1SimilarityFunction STATIC = new Kulczynski1SimilarityFunction();

    @Deprecated
    public Kulczynski1SimilarityFunction() {
    }

    @Override
    public double distance(NumberVector v1, NumberVector v2) {
        int dim = Kulczynski1SimilarityFunction.dimensionality(v1, v2);
        double sumdiff = 0.0;
        double summin = 0.0;
        for (int d = 0; d < dim; ++d) {
            double yd;
            double xd = v1.doubleValue(d);
            if (xd >= (yd = v2.doubleValue(d))) {
                sumdiff += xd - yd;
                summin += yd;
                continue;
            }
            sumdiff += yd - xd;
            summin += xd;
        }
        return summin > 0.0 ? sumdiff / summin : 0.0;
    }

    @Override
    public double minDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        int dim = Kulczynski1SimilarityFunction.dimensionality(mbr1, mbr2);
        double sumdiff = 0.0;
        double summin = 0.0;
        for (int d = 0; d < dim; ++d) {
            double min1 = mbr1.getMin(d);
            double max1 = mbr1.getMax(d);
            double min2 = mbr2.getMin(d);
            double max2 = mbr2.getMax(d);
            sumdiff += max1 < min2 ? min2 - max1 : (min1 > max2 ? min1 - max2 : 0.0);
            summin += min1 < min2 ? min1 : min2;
        }
        return summin > 0.0 ? sumdiff / summin : 0.0;
    }

    @Override
    public double similarity(NumberVector v1, NumberVector v2) {
        int dim = AbstractNumberVectorDistanceFunction.dimensionality(v1, v2);
        double sumdiff = 0.0;
        double summin = 0.0;
        for (int i = 0; i < dim; ++i) {
            double xi = v1.doubleValue(i);
            double yi = v2.doubleValue(i);
            sumdiff += Math.abs(xi - yi);
            summin += Math.min(xi, yi);
        }
        return summin / sumdiff;
    }

    @Override
    public boolean isSymmetric() {
        return true;
    }

    @Override
    public <T extends NumberVector> SpatialPrimitiveDistanceSimilarityQuery<T> instantiate(Relation<T> database) {
        return new SpatialPrimitiveDistanceSimilarityQuery<NumberVector>(database, this, this);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected Kulczynski1SimilarityFunction makeInstance() {
            return STATIC;
        }
    }
}

