/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.similarityfunction;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.AbstractVectorSimilarityFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="M.-M. Deza, E. Deza", title="Dictionary of distances", booktitle="Dictionary of distances", url="https://doi.org/10.1007/978-3-642-00234-2", bibkey="doi:10.1007/978-3-642-00234-2")
public class Kulczynski2SimilarityFunction
extends AbstractVectorSimilarityFunction {
    public static final Kulczynski2SimilarityFunction STATIC_CONTINUOUS = new Kulczynski2SimilarityFunction();

    @Deprecated
    public Kulczynski2SimilarityFunction() {
    }

    @Override
    public double similarity(NumberVector v1, NumberVector v2) {
        int dim = AbstractNumberVectorDistanceFunction.dimensionality(v1, v2);
        double sumx = 0.0;
        double sumy = 0.0;
        double summin = 0.0;
        for (int i = 0; i < dim; ++i) {
            double xi = v1.doubleValue(i);
            double yi = v2.doubleValue(i);
            sumx += xi;
            sumy += yi;
            summin += Math.min(xi, yi);
        }
        return (double)dim * 0.5 * ((double)dim / sumx + (double)dim / sumy) * summin;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected Kulczynski2SimilarityFunction makeInstance() {
            return STATIC_CONTINUOUS;
        }
    }
}

