/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.similarityfunction.cluster;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.query.DistanceSimilarityQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.PrimitiveDistanceSimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.PrimitiveSimilarityFunction;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class ClusterIntersectionSimilarityFunction
implements PrimitiveDistanceFunction<Cluster<?>>,
PrimitiveSimilarityFunction<Cluster<?>> {
    public static final ClusterIntersectionSimilarityFunction STATIC = new ClusterIntersectionSimilarityFunction();

    @Override
    public double similarity(Cluster<?> o1, Cluster<?> o2) {
        return DBIDUtil.intersectionSize(o1.getIDs(), o2.getIDs());
    }

    @Override
    public double distance(Cluster<?> o1, Cluster<?> o2) {
        int i = DBIDUtil.intersectionSize(o1.getIDs(), o2.getIDs());
        return Math.max(o1.size(), o2.size()) - i;
    }

    @Override
    public boolean isSymmetric() {
        return true;
    }

    @Override
    public boolean isMetric() {
        return false;
    }

    @Override
    public <T extends Cluster<?>> DistanceSimilarityQuery<T> instantiate(Relation<T> relation) {
        return new PrimitiveDistanceSimilarityQuery<T>(relation, this, this);
    }

    @Override
    public SimpleTypeInformation<? super Cluster<?>> getInputTypeRestriction() {
        return new SimpleTypeInformation<Cluster>(Cluster.class);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected ClusterIntersectionSimilarityFunction makeInstance() {
            return STATIC;
        }
    }
}

