/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.similarityfunction.cluster;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.query.DistanceSimilarityQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.PrimitiveDistanceSimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.PrimitiveSimilarityFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="P. Jaccard", title="Distribution de la florine alpine dans la Bassin de Dranses et dans quelques regiones voisines", booktitle="Bulletin del la Soci\u00e9t\u00e9 Vaudoise des Sciences Naturelles", url="http://data.rero.ch/01-R241574160", bibkey="journals/misc/Jaccard1902")
public class ClusterJaccardSimilarityFunction
implements PrimitiveDistanceFunction<Cluster<?>>,
PrimitiveSimilarityFunction<Cluster<?>> {
    public static final ClusterJaccardSimilarityFunction STATIC = new ClusterJaccardSimilarityFunction();

    @Override
    public double similarity(Cluster<?> o1, Cluster<?> o2) {
        int i = DBIDUtil.intersectionSize(o1.getIDs(), o2.getIDs());
        int union = o1.size() + o2.size() - i;
        return (double)i / (double)union;
    }

    @Override
    public double distance(Cluster<?> o1, Cluster<?> o2) {
        int i = DBIDUtil.intersectionSize(o1.getIDs(), o2.getIDs());
        int union = o1.size() + o2.size() - i;
        return 1.0 - (double)i / (double)union;
    }

    @Override
    public boolean isSymmetric() {
        return true;
    }

    @Override
    public boolean isMetric() {
        return true;
    }

    @Override
    public <T extends Cluster<?>> DistanceSimilarityQuery<T> instantiate(Relation<T> relation) {
        return new PrimitiveDistanceSimilarityQuery<T>(relation, this, this);
    }

    @Override
    public SimpleTypeInformation<? super Cluster<?>> getInputTypeRestriction() {
        return new SimpleTypeInformation<Cluster>(Cluster.class);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected ClusterJaccardSimilarityFunction makeInstance() {
            return STATIC;
        }
    }
}

