/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.similarityfunction.cluster;

import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.database.query.DistanceSimilarityQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.PrimitiveDistanceSimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.NormalizedSimilarityFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.cluster.ClusteringDistanceSimilarityFunction;
import de.lmu.ifi.dbs.elki.evaluation.clustering.ClusterContingencyTable;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="L. Hubert, P. Arabie", title="Comparing partitions", booktitle="Journal of Classification 2(193)", url="https://doi.org/10.1007/BF01908075", bibkey="doi:10.1007/BF01908075")
public class ClusteringAdjustedRandIndexSimilarityFunction
implements ClusteringDistanceSimilarityFunction,
NormalizedSimilarityFunction<Clustering<?>> {
    public static final ClusteringAdjustedRandIndexSimilarityFunction STATIC = new ClusteringAdjustedRandIndexSimilarityFunction();

    @Override
    public double similarity(Clustering<?> o1, Clustering<?> o2) {
        ClusterContingencyTable ct = new ClusterContingencyTable(false, true);
        ct.process(o1, o2);
        return ct.getPaircount().adjustedRandIndex();
    }

    @Override
    public double distance(Clustering<?> o1, Clustering<?> o2) {
        ClusterContingencyTable ct = new ClusterContingencyTable(false, true);
        ct.process(o1, o2);
        return 1.0 - ct.getPaircount().adjustedRandIndex();
    }

    @Override
    public boolean isMetric() {
        return false;
    }

    @Override
    public <T extends Clustering<?>> DistanceSimilarityQuery<T> instantiate(Relation<T> relation) {
        return new PrimitiveDistanceSimilarityQuery<T>(relation, this, this);
    }

    @Override
    public SimpleTypeInformation<? super Clustering<?>> getInputTypeRestriction() {
        return new SimpleTypeInformation<Clustering>(Clustering.class);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected ClusteringAdjustedRandIndexSimilarityFunction makeInstance() {
            return STATIC;
        }
    }
}

