/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.similarityfunction.cluster;

import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.database.query.DistanceSimilarityQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.PrimitiveDistanceSimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.NormalizedSimilarityFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.cluster.ClusteringDistanceSimilarityFunction;
import de.lmu.ifi.dbs.elki.evaluation.clustering.ClusterContingencyTable;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="A. Bagga, B. Baldwin", title="Entity-based cross-document coreferencing using the Vector Space Model", booktitle="Proc. 17th Int. Conf. on Computational Linguistics (COLING '98)", url="https://doi.org/10.3115/980451.980859", bibkey="doi:10.3115/980451.980859")
public class ClusteringBCubedF1SimilarityFunction
implements ClusteringDistanceSimilarityFunction,
NormalizedSimilarityFunction<Clustering<?>> {
    public static final ClusteringBCubedF1SimilarityFunction STATIC = new ClusteringBCubedF1SimilarityFunction();

    @Override
    public double similarity(Clustering<?> o1, Clustering<?> o2) {
        ClusterContingencyTable ct = new ClusterContingencyTable(false, true);
        ct.process(o1, o2);
        return ct.getBCubed().f1Measure();
    }

    @Override
    public double distance(Clustering<?> o1, Clustering<?> o2) {
        ClusterContingencyTable ct = new ClusterContingencyTable(false, true);
        ct.process(o1, o2);
        return 1.0 - ct.getBCubed().f1Measure();
    }

    @Override
    public boolean isMetric() {
        return false;
    }

    @Override
    public <T extends Clustering<?>> DistanceSimilarityQuery<T> instantiate(Relation<T> relation) {
        return new PrimitiveDistanceSimilarityQuery<T>(relation, this, this);
    }

    @Override
    public SimpleTypeInformation<? super Clustering<?>> getInputTypeRestriction() {
        return new SimpleTypeInformation<Clustering>(Clustering.class);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected ClusteringBCubedF1SimilarityFunction makeInstance() {
            return STATIC;
        }
    }
}

