/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.similarityfunction.cluster;

import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.database.query.DistanceSimilarityQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.PrimitiveDistanceSimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.cluster.ClusteringDistanceSimilarityFunction;
import de.lmu.ifi.dbs.elki.evaluation.clustering.ClusterContingencyTable;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="W. M. Rand", title="Objective Criteria for the Evaluation of Clustering Methods", booktitle="Journal of the American Statistical Association, Vol. 66 Issue 336", url="https://doi.org/10.2307/2284239", bibkey="doi:10.2307/2284239")
public class ClusteringRandIndexSimilarityFunction
implements ClusteringDistanceSimilarityFunction {
    public static final ClusteringRandIndexSimilarityFunction STATIC = new ClusteringRandIndexSimilarityFunction();

    @Override
    public double similarity(Clustering<?> o1, Clustering<?> o2) {
        ClusterContingencyTable ct = new ClusterContingencyTable(false, true);
        ct.process(o1, o2);
        return ct.getPaircount().randIndex();
    }

    @Override
    public double distance(Clustering<?> o1, Clustering<?> o2) {
        ClusterContingencyTable ct = new ClusterContingencyTable(false, true);
        ct.process(o1, o2);
        return 1.0 - ct.getPaircount().randIndex();
    }

    @Override
    public boolean isMetric() {
        return false;
    }

    @Override
    public <T extends Clustering<?>> DistanceSimilarityQuery<T> instantiate(Relation<T> relation) {
        return new PrimitiveDistanceSimilarityQuery<T>(relation, this, this);
    }

    @Override
    public SimpleTypeInformation<? super Clustering<?>> getInputTypeRestriction() {
        return new SimpleTypeInformation<Clustering>(Clustering.class);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected ClusteringRandIndexSimilarityFunction makeInstance() {
            return STATIC;
        }
    }
}

