/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.similarityfunction.kernel;

import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.similarity.SimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.PrimitiveSimilarityFunction;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import java.util.Arrays;
import java.util.logging.Level;
import net.jafama.FastMath;

public class KernelMatrix {
    double[][] kernel;
    DBIDMap idmap;

    public <O> KernelMatrix(PrimitiveSimilarityFunction<? super O> kernelFunction, Relation<? extends O> relation, DBIDs ids) {
        this.kernel = new double[ids.size()][ids.size()];
        this.idmap = ids instanceof DBIDRange ? new RangeMap((DBIDRange)ids) : new SortedArrayMap(ids);
        DBIDArrayIter i1 = this.idmap.iter();
        DBIDArrayIter i2 = this.idmap.iter();
        i1.seek(0);
        while (i1.valid()) {
            O o1 = relation.get(i1);
            i2.seek(i1.getOffset());
            while (i2.valid()) {
                double value;
                this.kernel[i1.getOffset()][i2.getOffset()] = value = kernelFunction.similarity(o1, relation.get(i2));
                this.kernel[i2.getOffset()][i1.getOffset()] = value;
                i2.advance();
            }
            i1.advance();
        }
    }

    public <O> KernelMatrix(SimilarityQuery<? super O> kernelFunction, Relation<? extends O> relation, DBIDs ids) {
        LoggingUtil.logExpensive(Level.FINER, "Computing kernel matrix");
        this.kernel = new double[ids.size()][ids.size()];
        this.idmap = ids instanceof DBIDRange ? new RangeMap((DBIDRange)ids) : new SortedArrayMap(ids);
        DBIDArrayIter i1 = this.idmap.iter();
        DBIDArrayIter i2 = this.idmap.iter();
        i1.seek(0);
        while (i1.valid()) {
            O o1 = relation.get(i1);
            i2.seek(i1.getOffset());
            while (i2.valid()) {
                double value;
                this.kernel[i1.getOffset()][i2.getOffset()] = value = kernelFunction.similarity((DBIDArrayIter)o1, i2);
                this.kernel[i2.getOffset()][i1.getOffset()] = value;
                i2.advance();
            }
            i1.advance();
        }
    }

    public KernelMatrix(double[][] matrix) {
        this.kernel = VMath.copy(matrix);
    }

    public double getDistance(DBIDRef o1, DBIDRef o2) {
        return FastMath.sqrt(this.getSquaredDistance(o1, o2));
    }

    public double[][] getKernel() {
        return this.kernel;
    }

    public double getSquaredDistance(DBIDRef id1, DBIDRef id2) {
        int o1 = this.idmap.getOffset(id1);
        int o2 = this.idmap.getOffset(id2);
        return this.kernel[o1][o1] + this.kernel[o2][o2] - 2.0 * this.kernel[o1][o2];
    }

    public static double[][] centerMatrix(double[][] matrix) {
        double[][] normalizingMatrix;
        for (double[] row : normalizingMatrix = new double[matrix.length][matrix[0].length]) {
            Arrays.fill(row, 1.0 / (double)matrix[0].length);
        }
        return VMath.times(VMath.plusEquals(VMath.minusEquals(VMath.minus(matrix, VMath.times(normalizingMatrix, matrix)), VMath.times(matrix, normalizingMatrix)), VMath.times(normalizingMatrix, matrix)), normalizingMatrix);
    }

    public static double[][] centerKernelMatrix(KernelMatrix kernelMatrix) {
        return KernelMatrix.centerMatrix(kernelMatrix.getKernel());
    }

    public double getSimilarity(DBIDRef id1, DBIDRef id2) {
        return this.kernel[this.idmap.getOffset(id1)][this.idmap.getOffset(id2)];
    }

    private class SortedArrayMap
    implements DBIDMap {
        ArrayModifiableDBIDs ids;

        public SortedArrayMap(DBIDs ids) {
            this.ids = DBIDUtil.newArray(ids);
            this.ids.sort();
        }

        @Override
        public int getOffset(DBIDRef id) {
            return this.ids.binarySearch(id);
        }

        @Override
        public DBIDArrayIter iter() {
            return this.ids.iter();
        }
    }

    private class RangeMap
    implements DBIDMap {
        DBIDRange range;

        public RangeMap(DBIDRange range) {
            this.range = range;
        }

        @Override
        public int getOffset(DBIDRef id) {
            return this.range.getOffset(id);
        }

        @Override
        public DBIDArrayIter iter() {
            return this.range.iter();
        }
    }

    private static interface DBIDMap {
        public int getOffset(DBIDRef var1);

        public DBIDArrayIter iter();
    }
}

