/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.similarityfunction.kernel;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.AbstractVectorSimilarityFunction;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import net.jafama.FastMath;

public class LaplaceKernelFunction
extends AbstractVectorSimilarityFunction {
    private final double mgamma;

    public LaplaceKernelFunction(double sigma) {
        this.mgamma = -0.5 / (sigma * sigma);
    }

    @Override
    public double similarity(NumberVector o1, NumberVector o2) {
        int dim = AbstractNumberVectorDistanceFunction.dimensionality(o1, o2);
        double sim = 0.0;
        for (int i = 0; i < dim; ++i) {
            double v = o1.doubleValue(i) - o2.doubleValue(i);
            sim += v * v;
        }
        return FastMath.exp(this.mgamma * FastMath.sqrt(sim));
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID SIGMA_ID = new OptionID("kernel.laplace.sigma", "Standard deviation of the laplace RBF kernel.");
        protected double sigma = 1.0;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleParameter sigmaP = (DoubleParameter)new DoubleParameter(SIGMA_ID, 1.0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (config.grab(sigmaP)) {
                this.sigma = sigmaP.doubleValue();
            }
        }

        @Override
        protected LaplaceKernelFunction makeInstance() {
            return new LaplaceKernelFunction(this.sigma);
        }
    }
}

