/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.similarityfunction.kernel;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.VectorUtil;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.kernel.PolynomialKernelFunction;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

@Priority(value=200)
public class LinearKernelFunction
extends PolynomialKernelFunction {
    public static final LinearKernelFunction STATIC = new LinearKernelFunction();

    @Deprecated
    public LinearKernelFunction() {
        super(1, 0.0);
    }

    @Override
    public double similarity(NumberVector o1, NumberVector o2) {
        return VectorUtil.dot(o1, o2);
    }

    @Override
    public double distance(NumberVector fv1, NumberVector fv2) {
        return FastMath.sqrt(this.similarity(fv1, fv1) + this.similarity(fv2, fv2) - 2.0 * this.similarity(fv1, fv2));
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LinearKernelFunction makeInstance() {
            return STATIC;
        }
    }
}

