/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.similarityfunction.kernel;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.VectorUtil;
import de.lmu.ifi.dbs.elki.database.query.DistanceSimilarityQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.PrimitiveDistanceSimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.AbstractVectorSimilarityFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.kernel.LinearKernelFunction;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import net.jafama.FastMath;

public class PolynomialKernelFunction
extends AbstractVectorSimilarityFunction
implements PrimitiveDistanceFunction<NumberVector> {
    public static final int DEFAULT_DEGREE = 2;
    private final int degree;
    private final double bias;

    public PolynomialKernelFunction(int degree, double bias) {
        this.degree = degree;
        this.bias = bias;
    }

    public PolynomialKernelFunction(int degree) {
        this(degree, 0.0);
    }

    @Override
    public double similarity(NumberVector o1, NumberVector o2) {
        return MathUtil.powi(VectorUtil.dot(o1, o2) + this.bias, this.degree);
    }

    @Override
    public boolean isSymmetric() {
        return true;
    }

    @Override
    public boolean isMetric() {
        return true;
    }

    @Override
    public double distance(NumberVector fv1, NumberVector fv2) {
        return FastMath.sqrt(this.similarity(fv1, fv1) + this.similarity(fv2, fv2) - 2.0 * this.similarity(fv1, fv2));
    }

    @Override
    public <T extends NumberVector> DistanceSimilarityQuery<T> instantiate(Relation<T> database) {
        return new PrimitiveDistanceSimilarityQuery<NumberVector>(database, this, this);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID DEGREE_ID = new OptionID("kernel.polynomial.degree", "The degree of the polynomial kernel function. Default: 2");
        public static final OptionID BIAS_ID = new OptionID("kernel.polynomial.bias", "The bias of the polynomial kernel, a constant that is added to the scalar product.");
        protected int degree = 0;
        protected double bias = 0.0;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter biasP;
            super.makeOptions(config);
            IntParameter degreeP = (IntParameter)new IntParameter(DEGREE_ID, 2).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(degreeP)) {
                this.degree = degreeP.intValue();
            }
            if (config.grab(biasP = (DoubleParameter)new DoubleParameter(BIAS_ID).setOptional(true))) {
                this.bias = biasP.doubleValue();
            }
        }

        @Override
        protected PolynomialKernelFunction makeInstance() {
            if (this.degree == 1 && this.bias == 0.0) {
                return LinearKernelFunction.STATIC;
            }
            return new PolynomialKernelFunction(this.degree, this.bias);
        }
    }
}

