/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.similarityfunction.kernel;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.AbstractVectorSimilarityFunction;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;

public class RationalQuadraticKernelFunction
extends AbstractVectorSimilarityFunction {
    private final double c;

    public RationalQuadraticKernelFunction(double c) {
        this.c = c;
    }

    @Override
    public double similarity(NumberVector o1, NumberVector o2) {
        int dim = AbstractNumberVectorDistanceFunction.dimensionality(o1, o2);
        double sim = 0.0;
        for (int i = 0; i < dim; ++i) {
            double v = o1.doubleValue(i) - o2.doubleValue(i);
            sim += v * v;
        }
        return 1.0 - sim / (sim + this.c);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID C_ID = new OptionID("kernel.rationalquadratic.c", "Constant term in the rational quadratic kernel.");
        protected double c = 1.0;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleParameter cP = (DoubleParameter)new DoubleParameter(C_ID, 1.0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (config.grab(cP)) {
                this.c = cP.doubleValue();
            }
        }

        @Override
        protected RationalQuadraticKernelFunction makeInstance() {
            return new RationalQuadraticKernelFunction(this.c);
        }
    }
}

