/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.similarityfunction.kernel;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.AbstractVectorSimilarityFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import net.jafama.FastMath;

@Alias(value={"sigmoid"})
public class SigmoidKernelFunction
extends AbstractVectorSimilarityFunction {
    private final double c;
    private final double theta;

    public SigmoidKernelFunction(double c, double theta) {
        this.c = c;
        this.theta = theta;
    }

    @Override
    public double similarity(NumberVector o1, NumberVector o2) {
        int dim = AbstractNumberVectorDistanceFunction.dimensionality(o1, o2);
        double sim = 0.0;
        for (int i = 0; i < dim; ++i) {
            double v = o1.doubleValue(i) * o2.doubleValue(i);
            sim += v;
        }
        return FastMath.tanh(this.c * sim + this.theta);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID C_ID = new OptionID("kernel.sigmoid.c", "Sigmoid c parameter (scaling).");
        public static final OptionID THETA_ID = new OptionID("kernel.sigmoid.theta", "Sigmoid theta parameter (bias).");
        protected double c = 1.0;
        protected double theta = 0.0;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter thetaP;
            super.makeOptions(config);
            DoubleParameter cP = new DoubleParameter(C_ID, 1.0);
            if (config.grab(cP)) {
                this.c = cP.doubleValue();
            }
            if (config.grab(thetaP = new DoubleParameter(THETA_ID, 0.0))) {
                this.theta = thetaP.doubleValue();
            }
        }

        @Override
        protected SigmoidKernelFunction makeInstance() {
            return new SigmoidKernelFunction(this.c, this.theta);
        }
    }
}

