/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation;

import de.lmu.ifi.dbs.elki.algorithm.clustering.trivial.ByLabelClustering;
import de.lmu.ifi.dbs.elki.algorithm.clustering.trivial.ByLabelOrAllInOneClustering;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.type.NoSupportedDataTypeException;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.evaluation.clustering.EvaluateClustering;
import de.lmu.ifi.dbs.elki.evaluation.outlier.ComputeOutlierHistogram;
import de.lmu.ifi.dbs.elki.evaluation.outlier.OutlierPrecisionAtKCurve;
import de.lmu.ifi.dbs.elki.evaluation.outlier.OutlierPrecisionRecallCurve;
import de.lmu.ifi.dbs.elki.evaluation.outlier.OutlierROCCurve;
import de.lmu.ifi.dbs.elki.evaluation.outlier.OutlierRankingEvaluation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.scaling.LinearScaling;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;

public class AutomaticEvaluation
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(AutomaticEvaluation.class);

    @Override
    public void processNewResult(ResultHierarchy hier, Result newResult) {
        this.autoEvaluateClusterings(hier, newResult);
        this.autoEvaluateOutliers(hier, newResult);
    }

    protected void autoEvaluateOutliers(ResultHierarchy hier, Result newResult) {
        ArrayList<OutlierResult> outliers = ResultUtil.filterResults(hier, newResult, OutlierResult.class);
        if (LOG.isDebugging()) {
            LOG.debug("Number of new outlier results: " + outliers.size());
        }
        if (!outliers.isEmpty()) {
            Database db = ResultUtil.findDatabase(hier);
            AutomaticEvaluation.ensureClusteringResult(db, db);
            ArrayList<Clustering> clusterings = ResultUtil.filterResults(hier, db, Clustering.class);
            if (clusterings.isEmpty()) {
                LOG.warning("Could not find a clustering result, even after running 'ensureClusteringResult'?!?");
                return;
            }
            Clustering basec = (Clustering)clusterings.iterator().next();
            int min = Integer.MAX_VALUE;
            int total = 0;
            String label = null;
            if (basec.getAllClusters().size() > 1) {
                for (Cluster c : basec.getAllClusters()) {
                    int csize = c.getIDs().size();
                    total += csize;
                    if (csize >= min) continue;
                    min = csize;
                    label = c.getName();
                }
            }
            if (label == null) {
                LOG.warning("Could not evaluate outlier results, as I could not find a minority label.");
                return;
            }
            if (min == 1) {
                LOG.warning("The minority class label had a single object. Try using 'ClassLabelFilter' to identify the class label column.");
            }
            if ((double)min > 0.05 * (double)total) {
                LOG.warning("The minority class I discovered (labeled '" + label + "') has " + (double)min * 100.0 / (double)total + "% of objects. Outlier classes should be more rare!");
            }
            LOG.verbose("Evaluating using minority class: " + label);
            Pattern pat = Pattern.compile("^" + Pattern.quote(label) + "$");
            new OutlierRankingEvaluation(pat).processNewResult(hier, newResult);
            new OutlierROCCurve(pat).processNewResult(hier, newResult);
            new OutlierPrecisionAtKCurve(pat, min << 1).processNewResult(hier, newResult);
            new OutlierPrecisionRecallCurve(pat).processNewResult(hier, newResult);
            new ComputeOutlierHistogram(pat, 50, new LinearScaling(), false).processNewResult(hier, newResult);
        }
    }

    protected void autoEvaluateClusterings(ResultHierarchy hier, Result newResult) {
        ArrayList<Clustering> clusterings = ResultUtil.filterResults(hier, newResult, Clustering.class);
        if (LOG.isDebugging()) {
            LOG.warning("Number of new clustering results: " + clusterings.size());
        }
        Iterator c = clusterings.iterator();
        while (c.hasNext()) {
            Clustering test = (Clustering)c.next();
            if ("allinone-clustering".equals(test.getShortName())) {
                c.remove();
                continue;
            }
            if ("allinnoise-clustering".equals(test.getShortName())) {
                c.remove();
                continue;
            }
            if ("bylabel-clustering".equals(test.getShortName())) {
                c.remove();
                continue;
            }
            if (!"bymodel-clustering".equals(test.getShortName())) continue;
            c.remove();
        }
        if (!clusterings.isEmpty()) {
            try {
                new EvaluateClustering(new ByLabelClustering(), false, true).processNewResult(hier, newResult);
            }
            catch (NoSupportedDataTypeException noSupportedDataTypeException) {
                // empty catch block
            }
        }
    }

    public static void ensureClusteringResult(Database db, Result result) {
        ArrayList<Clustering> clusterings = ResultUtil.filterResults(db.getHierarchy(), result, Clustering.class);
        if (clusterings.isEmpty()) {
            ResultUtil.addChildResult(db, new ByLabelOrAllInOneClustering().run(db));
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected AutomaticEvaluation makeInstance() {
            return new AutomaticEvaluation();
        }
    }
}

