/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.classification.holdout;

import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.evaluation.classification.holdout.AbstractHoldout;
import de.lmu.ifi.dbs.elki.evaluation.classification.holdout.TrainingAndTestSet;
import java.util.ArrayList;

public class LeaveOneOut
extends AbstractHoldout {
    private int len;
    private int pos;

    @Override
    public void initialize(MultipleObjectsBundle bundle) {
        super.initialize(bundle);
        this.len = bundle.dataLength();
        this.pos = 0;
    }

    @Override
    public int numberOfPartitions() {
        return this.len;
    }

    @Override
    public TrainingAndTestSet nextPartitioning() {
        if (this.pos >= this.len) {
            return null;
        }
        MultipleObjectsBundle training = new MultipleObjectsBundle();
        MultipleObjectsBundle test = new MultipleObjectsBundle();
        int cs = this.bundle.metaLength();
        for (int c = 0; c < cs; ++c) {
            ArrayList<Object> tr = new ArrayList<Object>(this.len - 1);
            ArrayList te = new ArrayList(1);
            for (int i = 0; i < this.bundle.dataLength(); ++i) {
                (i != this.pos ? tr : te).add(this.bundle.data(i, c));
            }
            training.appendColumn(this.bundle.meta(c), tr);
            test.appendColumn(this.bundle.meta(c), te);
        }
        ++this.pos;
        return new TrainingAndTestSet(training, test, this.labels);
    }
}

