/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.classification.holdout;

import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.evaluation.classification.holdout.RandomizedHoldout;
import de.lmu.ifi.dbs.elki.evaluation.classification.holdout.TrainingAndTestSet;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.ArrayList;
import java.util.Random;

public class RandomizedCrossValidation
extends RandomizedHoldout {
    protected int nfold;
    protected int fold;

    public RandomizedCrossValidation(RandomFactory random, int nfold) {
        super(random);
        this.nfold = nfold;
    }

    @Override
    public void initialize(MultipleObjectsBundle bundle) {
        super.initialize(bundle);
        this.fold = 0;
    }

    @Override
    public int numberOfPartitions() {
        return this.nfold;
    }

    @Override
    public TrainingAndTestSet nextPartitioning() {
        if (this.fold >= this.nfold) {
            return null;
        }
        MultipleObjectsBundle training = new MultipleObjectsBundle();
        MultipleObjectsBundle test = new MultipleObjectsBundle();
        Random rnd = this.random.getRandom();
        int datalen = this.bundle.dataLength();
        boolean[] assignment = new boolean[datalen];
        int trsize = 0;
        int tesize = 0;
        for (int i = 0; i < assignment.length; ++i) {
            boolean p;
            assignment[i] = p = rnd.nextInt(this.nfold) < this.nfold - 1;
            int n = p ? ++trsize : ++tesize;
        }
        int cs = this.bundle.metaLength();
        for (int c = 0; c < cs; ++c) {
            ArrayList<Object> tr = new ArrayList<Object>(trsize);
            ArrayList te = new ArrayList(tesize);
            for (int i = 0; i < datalen; ++i) {
                (assignment[i] ? tr : te).add(this.bundle.data(i, c));
            }
            training.appendColumn(this.bundle.meta(c), tr);
            test.appendColumn(this.bundle.meta(c), te);
        }
        ++this.fold;
        return new TrainingAndTestSet(training, test, this.labels);
    }

    public static class Parameterizer
    extends RandomizedHoldout.Parameterizer {
        public static final OptionID NFOLD_ID = new OptionID("nfold", "positive number of folds for cross-validation");
        public static final int N_DEFAULT = 10;
        protected int nfold;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter nfoldP = (IntParameter)((IntParameter)new IntParameter(NFOLD_ID).setDefaultValue((Object)10)).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(nfoldP)) {
                this.nfold = nfoldP.intValue();
            }
        }

        @Override
        protected RandomizedCrossValidation makeInstance() {
            return new RandomizedCrossValidation(this.random, this.nfold);
        }
    }
}

