/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.classification.holdout;

import de.lmu.ifi.dbs.elki.data.ClassLabel;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.evaluation.classification.holdout.AbstractHoldout;
import de.lmu.ifi.dbs.elki.evaluation.classification.holdout.TrainingAndTestSet;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collections;

public class StratifiedCrossValidation
extends AbstractHoldout {
    protected int nfold;
    protected int fold;
    protected int[] assignment;
    protected int[] sizes;

    public StratifiedCrossValidation(int nfold) {
        this.nfold = nfold;
    }

    @Override
    public int numberOfPartitions() {
        return this.nfold;
    }

    @Override
    public void initialize(MultipleObjectsBundle bundle) {
        int i;
        super.initialize(bundle);
        this.fold = 0;
        IntArrayList[] classBuckets = new IntArrayList[this.labels.size()];
        for (i = 0; i < this.labels.size(); ++i) {
            classBuckets[i] = new IntArrayList();
        }
        int l = bundle.dataLength();
        for (i = 0; i < l; ++i) {
            ClassLabel label = (ClassLabel)bundle.data(i, this.labelcol);
            if (label == null) {
                throw new AbortException("Unlabeled instances currently not supported.");
            }
            int classIndex = Collections.binarySearch(this.labels, label);
            if (classIndex < 0) {
                throw new AbortException("Label not in label list: " + label);
            }
            classBuckets[classIndex].add(i);
        }
        this.sizes = new int[this.nfold];
        this.assignment = new int[bundle.dataLength()];
        for (IntArrayList bucket : classBuckets) {
            for (int i2 = 0; i2 < bucket.size(); ++i2) {
                this.assignment[bucket.getInt((int)i2)] = i2 % this.nfold;
            }
        }
    }

    @Override
    public TrainingAndTestSet nextPartitioning() {
        if (this.fold >= this.nfold) {
            return null;
        }
        int tesize = this.sizes[this.fold];
        int trsize = this.bundle.dataLength() - tesize;
        MultipleObjectsBundle training = new MultipleObjectsBundle();
        MultipleObjectsBundle test = new MultipleObjectsBundle();
        int cs = this.bundle.metaLength();
        for (int c = 0; c < cs; ++c) {
            ArrayList<Object> tr = new ArrayList<Object>(trsize);
            ArrayList te = new ArrayList(tesize);
            for (int i = 0; i < this.bundle.dataLength(); ++i) {
                (this.assignment[i] != this.fold ? tr : te).add(this.bundle.data(i, c));
            }
            training.appendColumn(this.bundle.meta(c), tr);
            test.appendColumn(this.bundle.meta(c), te);
        }
        ++this.fold;
        return new TrainingAndTestSet(training, test, this.labels);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final int N_DEFAULT = 10;
        public static final OptionID NFOLD_ID = new OptionID("nfold", "Number of folds for cross-validation");
        protected int nfold;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter nfoldP = (IntParameter)new IntParameter(NFOLD_ID, 10).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(nfoldP)) {
                this.nfold = nfoldP.intValue();
            }
        }

        @Override
        protected StratifiedCrossValidation makeInstance() {
            return new StratifiedCrossValidation(this.nfold);
        }
    }
}

