/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering;

import de.lmu.ifi.dbs.elki.evaluation.clustering.ClusterContingencyTable;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="A. Bagga, B. Baldwin", title="Entity-based cross-document coreferencing using the Vector Space Model", booktitle="Proc. 17th Int. Conf. on Computational Linguistics (COLING '98)", url="https://doi.org/10.3115/980451.980859", bibkey="doi:10.3115/980451.980859")
public class BCubed {
    protected double bCubedPrecision = 0.0;
    protected double bCubedRecall = 0.0;

    protected BCubed(ClusterContingencyTable table) {
        for (int i1 = 0; i1 < table.size1; ++i1) {
            int[] row = table.contingency[i1];
            for (int i2 = 0; i2 < table.size2; ++i2) {
                int c = row[i2];
                if (c <= 0) continue;
                double precision = 1.0 * (double)c / (double)row[table.size2];
                this.bCubedPrecision += precision * (double)c;
                double recall = 1.0 * (double)c / (double)table.contingency[table.size1][i2];
                this.bCubedRecall += recall * (double)c;
            }
        }
        int total = table.contingency[table.size1][table.size2];
        this.bCubedPrecision /= (double)total;
        this.bCubedRecall /= (double)total;
    }

    public double precision() {
        return this.bCubedPrecision;
    }

    public double recall() {
        return this.bCubedRecall;
    }

    public double f1Measure() {
        return ClusterContingencyTable.Util.f1Measure(this.precision(), this.recall());
    }
}

