/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering;

import de.lmu.ifi.dbs.elki.evaluation.clustering.ClusterContingencyTable;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="P. Pantel, D. Lin", title="Document clustering with committees", booktitle="Proc. 25th ACM SIGIR Conf. on Research and Development in Information Retrieval", url="https://doi.org/10.1145/564376.564412", bibkey="DBLP:conf/sigir/PantelL02")
public class EditDistance {
    int editFirst = -1;
    int editSecond = -1;
    int editOperationsBaseline;

    protected EditDistance(ClusterContingencyTable table) {
        int largestLabelSet;
        this.editOperationsBaseline = table.contingency[table.size1][table.size2];
        this.editFirst = 0;
        for (int i1 = 0; i1 < table.size1; ++i1) {
            largestLabelSet = 0;
            for (int i2 = 0; i2 < table.size2; ++i2) {
                largestLabelSet = Math.max(largestLabelSet, table.contingency[i1][i2]);
            }
            ++this.editFirst;
            this.editFirst += table.contingency[i1][table.size2] - largestLabelSet;
        }
        this.editSecond = 0;
        for (int i2 = 0; i2 < table.size2; ++i2) {
            largestLabelSet = 0;
            for (int i1 = 0; i1 < table.size1; ++i1) {
                largestLabelSet = Math.max(largestLabelSet, table.contingency[i1][i2]);
            }
            ++this.editSecond;
            this.editSecond += table.contingency[table.size1][i2] - largestLabelSet;
        }
    }

    public int editOperationsBaseline() {
        return this.editOperationsBaseline;
    }

    public int editOperationsFirst() {
        return this.editFirst;
    }

    public int editOperationsSecond() {
        return this.editSecond;
    }

    public double editDistanceFirst() {
        return 1.0 - 1.0 * (double)this.editOperationsFirst() / (double)this.editOperationsBaseline();
    }

    public double editDistanceSecond() {
        return 1.0 - 1.0 * (double)this.editOperationsSecond() / (double)this.editOperationsBaseline();
    }

    public double f1Measure() {
        return ClusterContingencyTable.Util.f1Measure(this.editDistanceFirst(), this.editDistanceSecond());
    }
}

