/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering;

import de.lmu.ifi.dbs.elki.evaluation.clustering.ClusterContingencyTable;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import net.jafama.FastMath;

@Reference(authors="M. Meil\u0103", title="Comparing clusterings by the variation of information", booktitle="Learning theory and kernel machines", url="https://doi.org/10.1007/978-3-540-45167-9_14", bibkey="DBLP:conf/colt/Meila03")
public class Entropy {
    protected double entropyFirst = -1.0;
    protected double entropySecond = -1.0;
    protected double entropyJoint = -1.0;

    protected Entropy(ClusterContingencyTable table) {
        double probability;
        int i1;
        double norm = 1.0 / (double)table.contingency[table.size1][table.size2];
        this.entropyFirst = 0.0;
        for (i1 = 0; i1 < table.size1; ++i1) {
            if (table.contingency[i1][table.size2] <= 0) continue;
            probability = norm * (double)table.contingency[i1][table.size2];
            this.entropyFirst -= probability * FastMath.log(probability);
        }
        this.entropySecond = 0.0;
        for (int i2 = 0; i2 < table.size2; ++i2) {
            if (table.contingency[table.size1][i2] <= 0) continue;
            probability = norm * (double)table.contingency[table.size1][i2];
            this.entropySecond -= probability * FastMath.log(probability);
        }
        this.entropyJoint = 0.0;
        for (i1 = 0; i1 < table.size1; ++i1) {
            for (int i2 = 0; i2 < table.size2; ++i2) {
                if (table.contingency[i1][i2] <= 0) continue;
                double probability2 = norm * (double)table.contingency[i1][i2];
                this.entropyJoint -= probability2 * FastMath.log(probability2);
            }
        }
    }

    public double entropyFirst() {
        return this.entropyFirst;
    }

    public double entropySecond() {
        return this.entropySecond;
    }

    public double entropyJoint() {
        return this.entropyJoint;
    }

    public double entropyConditionalFirst() {
        return this.entropyJoint() - this.entropySecond();
    }

    public double entropyConditionalSecond() {
        return this.entropyJoint() - this.entropyFirst();
    }

    public double entropyPowers() {
        return 2.0 * this.entropyJoint() / (this.entropyFirst() + this.entropySecond()) - 1.0;
    }

    public double entropyMutualInformation() {
        return this.entropyFirst() + this.entropySecond() - this.entropyJoint();
    }

    public double entropyNMIJoint() {
        if (this.entropyJoint() == 0.0) {
            return 0.0;
        }
        return this.entropyMutualInformation() / this.entropyJoint();
    }

    public double entropyNMIMin() {
        return this.entropyMutualInformation() / Math.min(this.entropyFirst(), this.entropySecond());
    }

    public double entropyNMIMax() {
        return this.entropyMutualInformation() / Math.max(this.entropyFirst(), this.entropySecond());
    }

    public double entropyNMISum() {
        return 2.0 * this.entropyMutualInformation() / (this.entropyFirst() + this.entropySecond());
    }

    public double entropyNMISqrt() {
        if (this.entropyFirst() * this.entropySecond() <= 0.0) {
            return this.entropyMutualInformation();
        }
        return this.entropyMutualInformation() / FastMath.sqrt(this.entropyFirst() * this.entropySecond());
    }

    public double variationOfInformation() {
        return 2.0 * this.entropyJoint() - (this.entropyFirst() + this.entropySecond());
    }

    @Reference(authors="X. V. Nguyen, J. Epps, J. Bailey", title="Information theoretic measures for clusterings comparison: is a correction for chance necessary?", booktitle="Proc. 26th Ann. Int. Conf. on Machine Learning (ICML '09)", url="https://doi.org/10.1145/1553374.1553511", bibkey="DBLP:conf/icml/NguyenEB09")
    public double normalizedVariationOfInformation() {
        return 1.0 - this.entropyMutualInformation() / this.entropyJoint();
    }
}

