/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering;

import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.trivial.ByLabelOrAllInOneClustering;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.evaluation.clustering.BCubed;
import de.lmu.ifi.dbs.elki.evaluation.clustering.ClusterContingencyTable;
import de.lmu.ifi.dbs.elki.evaluation.clustering.EditDistance;
import de.lmu.ifi.dbs.elki.evaluation.clustering.Entropy;
import de.lmu.ifi.dbs.elki.evaluation.clustering.PairCounting;
import de.lmu.ifi.dbs.elki.evaluation.clustering.SetMatchingPurity;
import de.lmu.ifi.dbs.elki.evaluation.scores.ScoreEvaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.DBIDsTest;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.DistanceResultAdapter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.EvaluationResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;
import java.util.List;

@Alias(value={"de.lmu.ifi.dbs.elki.evaluation.paircounting.EvaluatePairCountingFMeasure"})
public class EvaluateClustering
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(EvaluateClustering.class);
    private ClusteringAlgorithm<?> referencealg;
    private boolean noiseSpecialHandling;
    private boolean selfPairing;

    public EvaluateClustering(ClusteringAlgorithm<?> referencealg, boolean noiseSpecialHandling, boolean selfPairing) {
        this.referencealg = referencealg;
        this.noiseSpecialHandling = noiseSpecialHandling;
        this.selfPairing = selfPairing;
    }

    public static double evaluateRanking(ScoreEvaluation eval, Cluster<?> clus, DoubleDBIDList ranking) {
        return eval.evaluate(new DBIDsTest(DBIDUtil.ensureSet(clus.getIDs())), new DistanceResultAdapter(ranking.iter()));
    }

    @Override
    public void processNewResult(ResultHierarchy hier, Result newResult) {
        if (newResult instanceof Clustering && this.isReferenceResult((Clustering)newResult)) {
            return;
        }
        Database db = ResultUtil.findDatabase(hier);
        List<Clustering<Model>> crs = Clustering.getClusteringResults(newResult);
        if (crs == null || crs.isEmpty()) {
            return;
        }
        Clustering refc = null;
        ArrayList<Clustering> cs = ResultUtil.filterResults(hier, db, Clustering.class);
        for (Clustering test : cs) {
            if (!this.isReferenceResult(test)) continue;
            refc = test;
            break;
        }
        if (refc == null) {
            cs = ResultUtil.filterResults(hier, newResult, Clustering.class);
            for (Clustering test : cs) {
                if (!this.isReferenceResult(test)) continue;
                refc = test;
                break;
            }
        }
        if (refc == null) {
            LOG.debug("Generating a new reference clustering.");
            Result refres = this.referencealg.run(db);
            List<Clustering<Model>> refcrs = Clustering.getClusteringResults(refres);
            if (refcrs.isEmpty()) {
                LOG.warning("Reference algorithm did not return a clustering result!");
                return;
            }
            if (refcrs.size() > 1) {
                LOG.warning("Reference algorithm returned more than one result!");
            }
            refc = refcrs.get(0);
        } else {
            LOG.debug("Using existing clustering: " + refc.getLongName() + " " + refc.getShortName());
        }
        for (Clustering<Model> c : crs) {
            if (c == refc) continue;
            this.evaluteResult(db, c, refc);
        }
    }

    protected void evaluteResult(Database db, Clustering<?> c, Clustering<?> refc) {
        ClusterContingencyTable contmat = new ClusterContingencyTable(this.selfPairing, this.noiseSpecialHandling);
        contmat.process(refc, c);
        ScoreResult sr = new ScoreResult(contmat);
        sr.addHeader(c.getLongName());
        db.getHierarchy().add(c, sr);
    }

    private boolean isReferenceResult(Clustering<?> t) {
        return "bylabel-clustering".equals(t.getShortName()) || "bymodel-clustering".equals(t.getShortName()) || "allinone-clustering".equals(t.getShortName()) || "allinnoise-clustering".equals(t.getShortName());
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID REFERENCE_ID = new OptionID("paircounting.reference", "Reference clustering to compare with. Defaults to a by-label clustering.");
        public static final OptionID NOISE_ID = new OptionID("paircounting.noisespecial", "Use special handling for noise clusters.");
        public static final OptionID SELFPAIR_ID = new OptionID("paircounting.selfpair", "Enable self-pairing for cluster comparison.");
        private ClusteringAlgorithm<?> referencealg;
        private boolean noiseSpecialHandling;
        private boolean selfPairing;

        @Override
        protected void makeOptions(Parameterization config) {
            Flag selfPairingF;
            Flag noiseSpecialHandlingF;
            super.makeOptions(config);
            ObjectParameter referencealgP = new ObjectParameter(REFERENCE_ID, (Class<?>)ClusteringAlgorithm.class, ByLabelOrAllInOneClustering.class);
            if (config.grab(referencealgP)) {
                this.referencealg = (ClusteringAlgorithm)referencealgP.instantiateClass(config);
            }
            if (config.grab(noiseSpecialHandlingF = new Flag(NOISE_ID))) {
                this.noiseSpecialHandling = (Boolean)noiseSpecialHandlingF.getValue();
            }
            if (config.grab(selfPairingF = new Flag(SELFPAIR_ID))) {
                this.selfPairing = (Boolean)selfPairingF.getValue();
            }
        }

        @Override
        protected EvaluateClustering makeInstance() {
            return new EvaluateClustering(this.referencealg, this.noiseSpecialHandling, !this.selfPairing);
        }
    }

    public static class ScoreResult
    extends EvaluationResult {
        protected ClusterContingencyTable contmat;

        public ScoreResult(ClusterContingencyTable contmat) {
            super("Cluster-Evalation", "cluster-evaluation");
            this.contmat = contmat;
            PairCounting paircount = contmat.getPaircount();
            EvaluationResult.MeasurementGroup g = this.newGroup("Pair counting measures");
            g.addMeasure("Jaccard", paircount.jaccard(), 0.0, 1.0, false);
            g.addMeasure("F1-Measure", paircount.f1Measure(), 0.0, 1.0, false);
            g.addMeasure("Precision", paircount.precision(), 0.0, 1.0, false);
            g.addMeasure("Recall", paircount.recall(), 0.0, 1.0, false);
            g.addMeasure("Rand", paircount.randIndex(), 0.0, 1.0, false);
            g.addMeasure("ARI", paircount.adjustedRandIndex(), 0.0, 1.0, false);
            g.addMeasure("FowlkesMallows", paircount.fowlkesMallows(), 0.0, 1.0, false);
            Entropy entropy = contmat.getEntropy();
            g = this.newGroup("Entropy based measures");
            g.addMeasure("NMI Joint", entropy.entropyNMIJoint(), 0.0, 1.0, false);
            g.addMeasure("NMI Sqrt", entropy.entropyNMISqrt(), 0.0, 1.0, false);
            BCubed bcubed = contmat.getBCubed();
            g = this.newGroup("BCubed-based measures");
            g.addMeasure("F1-Measure", bcubed.f1Measure(), 0.0, 1.0, false);
            g.addMeasure("Recall", bcubed.recall(), 0.0, 1.0, false);
            g.addMeasure("Precision", bcubed.precision(), 0.0, 1.0, false);
            SetMatchingPurity setm = contmat.getSetMatching();
            g = this.newGroup("Set-Matching-based measures");
            g.addMeasure("F1-Measure", setm.f1Measure(), 0.0, 1.0, false);
            g.addMeasure("Purity", setm.purity(), 0.0, 1.0, false);
            g.addMeasure("Inverse Purity", setm.inversePurity(), 0.0, 1.0, false);
            EditDistance edit = contmat.getEdit();
            g = this.newGroup("Editing-distance measures");
            g.addMeasure("F1-Measure", edit.f1Measure(), 0.0, 1.0, false);
            g.addMeasure("Precision", edit.editDistanceFirst(), 0.0, 1.0, false);
            g.addMeasure("Recall", edit.editDistanceSecond(), 0.0, 1.0, false);
            MeanVariance gini = contmat.averageSymmetricGini();
            g = this.newGroup("Gini measures");
            g.addMeasure("Mean +-" + FormatUtil.NF4.format(gini.getCount() > 1.0 ? gini.getSampleStddev() : 0.0), gini.getMean(), 0.0, 1.0, false);
        }

        public ClusterContingencyTable getContingencyTable() {
            return this.contmat;
        }

        @Override
        public boolean visualizeSingleton() {
            return true;
        }
    }
}

