/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.StringStatistic;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import java.util.List;

public class LogClusterSizes
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(LogClusterSizes.class);
    public static final String PREFIX = LogClusterSizes.class.getName() + ".";

    public static <C extends Model> void logClusterSizes(Clustering<C> c) {
        if (!LOG.isStatistics()) {
            return;
        }
        List<Cluster<C>> clusters = c.getAllClusters();
        int numc = clusters.size();
        LOG.statistics(new StringStatistic(PREFIX + "name", c.getLongName()));
        LOG.statistics(new LongStatistic(PREFIX + "clusters", numc));
        Hierarchy<Cluster<C>> h = c.getClusterHierarchy();
        int cnum = 0;
        for (Cluster<C> clu : clusters) {
            String p = PREFIX + "cluster-" + cnum + ".";
            if (clu.getName() != null) {
                LOG.statistics(new StringStatistic(p + "name", clu.getName()));
            }
            LOG.statistics(new LongStatistic(p + "size", clu.size()));
            if (clu.isNoise()) {
                LOG.statistics(new StringStatistic(p + "noise", "true"));
            }
            if (h.numChildren(clu) > 0) {
                StringBuilder buf = new StringBuilder();
                It<Cluster<C>> it = h.iterChildren(clu);
                while (it.valid()) {
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    buf.append(it.get().getName());
                    it.advance();
                }
                LOG.statistics(new StringStatistic(p + "children", buf.toString()));
            }
            ++cnum;
        }
    }

    @Override
    public void processNewResult(ResultHierarchy hier, Result result) {
        List<Clustering<Model>> crs = Clustering.getClusteringResults(result);
        if (crs == null || crs.isEmpty()) {
            return;
        }
        for (Clustering<Model> c : crs) {
            LogClusterSizes.logClusterSizes(c);
        }
    }
}

