/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering;

import de.lmu.ifi.dbs.elki.evaluation.clustering.ClusterContingencyTable;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import net.jafama.FastMath;

public class PairCounting {
    public static final long MAX_SIZE = (long)Math.floor(Math.sqrt(9.223372036854776E18));
    protected long[] pairconfuse = null;

    protected PairCounting(ClusterContingencyTable table) {
        int size;
        int i1;
        long inBoth = 0L;
        long in1 = 0L;
        long in2 = 0L;
        long total = 0L;
        for (i1 = 0; i1 < table.size1; ++i1) {
            size = table.contingency[i1][table.size2 + 1];
            if (table.breakNoiseClusters && BitsUtil.get(table.noise1, i1)) {
                if (!table.selfPairing) continue;
                in1 += (long)size;
                continue;
            }
            in1 += (long)size * (long)(table.selfPairing ? size : size - 1);
        }
        for (int i2 = 0; i2 < table.size2; ++i2) {
            size = table.contingency[table.size1 + 1][i2];
            if (table.breakNoiseClusters && BitsUtil.get(table.noise2, i2)) {
                if (!table.selfPairing) continue;
                in2 += (long)size;
                continue;
            }
            in2 += (long)size * (long)(table.selfPairing ? size : size - 1);
        }
        for (i1 = 0; i1 < table.size1; ++i1) {
            for (int i2 = 0; i2 < table.size2; ++i2) {
                int size2 = table.contingency[i1][i2];
                if (table.breakNoiseClusters && (BitsUtil.get(table.noise1, i1) || BitsUtil.get(table.noise2, i2))) {
                    if (!table.selfPairing) continue;
                    inBoth += (long)size2;
                    continue;
                }
                inBoth += (long)size2 * (long)(table.selfPairing ? size2 : size2 - 1);
            }
        }
        int tsize = table.contingency[table.size1][table.size2];
        if (table.contingency[table.size1][table.size2 + 1] != tsize || table.contingency[table.size1 + 1][table.size2] != tsize) {
            LoggingUtil.warning("PairCounting F-Measure is not well defined for overlapping and incomplete clusterings. The number of elements are: " + table.contingency[table.size1][table.size2 + 1] + " != " + table.contingency[table.size1 + 1][table.size2] + " elements.");
        }
        if (tsize < 0 || (long)tsize >= MAX_SIZE) {
            LoggingUtil.warning("Your data set size probably is too big for this implementation, which uses only long precision.");
        }
        total = (long)tsize * (long)(table.selfPairing ? tsize : tsize - 1);
        long inFirst = in1 - inBoth;
        long inSecond = in2 - inBoth;
        long inNone = total - (inBoth + inFirst + inSecond);
        this.pairconfuse = new long[]{inBoth, inFirst, inSecond, inNone};
    }

    public double fMeasure(double beta) {
        double beta2 = beta * beta;
        double fmeasure = (1.0 + beta2) * (double)this.pairconfuse[0] / ((1.0 + beta2) * (double)this.pairconfuse[0] + beta2 * (double)this.pairconfuse[1] + (double)this.pairconfuse[2]);
        return fmeasure;
    }

    public double f1Measure() {
        return this.fMeasure(1.0);
    }

    public double precision() {
        return (double)this.pairconfuse[0] / (double)(this.pairconfuse[0] + this.pairconfuse[2]);
    }

    public double recall() {
        return (double)this.pairconfuse[0] / (double)(this.pairconfuse[0] + this.pairconfuse[1]);
    }

    @Reference(authors="E. B. Fowlkes, C. L. Mallows", title="A method for comparing two hierarchical clusterings", booktitle="Journal of the American Statistical Association, Vol. 78 Issue 383", url="https://doi.org/10.2307/2288117", bibkey="doi:10.2307/2288117")
    public double fowlkesMallows() {
        return FastMath.sqrt(this.precision() * this.recall());
    }

    @Reference(authors="W. M. Rand", title="Objective Criteria for the Evaluation of Clustering Methods", booktitle="Journal of the American Statistical Association, Vol. 66 Issue 336", url="https://doi.org/10.2307/2284239", bibkey="doi:10.2307/2284239")
    public double randIndex() {
        double sum = this.pairconfuse[0] + this.pairconfuse[1] + this.pairconfuse[2] + this.pairconfuse[3];
        return (double)(this.pairconfuse[0] + this.pairconfuse[3]) / sum;
    }

    @Reference(authors="L. Hubert, P. Arabie", title="Comparing partitions", booktitle="Journal of Classification 2(193)", url="https://doi.org/10.1007/BF01908075", bibkey="doi:10.1007/BF01908075")
    public double adjustedRandIndex() {
        double d = FastMath.sqrt(this.pairconfuse[0] + this.pairconfuse[1] + this.pairconfuse[2] + this.pairconfuse[3]);
        double exp = (double)(this.pairconfuse[0] + this.pairconfuse[1]) / d * (double)(this.pairconfuse[0] + this.pairconfuse[2]) / d;
        double opt = (double)this.pairconfuse[0] + 0.5 * (double)(this.pairconfuse[1] + this.pairconfuse[2]);
        return ((double)this.pairconfuse[0] - exp) / (opt - exp);
    }

    @Reference(authors="P. Jaccard", title="Distribution de la florine alpine dans la Bassin de Dranses et dans quelques regiones voisines", booktitle="Bulletin del la Soci\u00e9t\u00e9 Vaudoise des Sciences Naturelles", url="http://data.rero.ch/01-R241574160", bibkey="journals/misc/Jaccard1902")
    public double jaccard() {
        double sum = this.pairconfuse[0] + this.pairconfuse[1] + this.pairconfuse[2];
        return (double)this.pairconfuse[0] / sum;
    }

    @Reference(authors="B. Mirkin", title="Mathematical Classification and Clustering", booktitle="Nonconvex Optimization and Its Applications", url="https://doi.org/10.1007/978-1-4613-0457-9", bibkey="doi:10.1007/978-1-4613-0457-9")
    public long mirkin() {
        return 2L * (this.pairconfuse[1] + this.pairconfuse[2]);
    }
}

