/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering;

import de.lmu.ifi.dbs.elki.evaluation.clustering.ClusterContingencyTable;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="M. Meil\u0103", title="Comparing clusterings", booktitle="University of Washington, Seattle, Technical Report 418", url="http://www.stat.washington.edu/mmp/Papers/compare-colt.pdf", bibkey="tr/washington/Meila02")
public class SetMatchingPurity {
    protected double smPurity = -1.0;
    protected double smInversePurity = -1.0;
    protected double smFFirst = -1.0;
    protected double smFSecond = -1.0;

    protected SetMatchingPurity(ClusterContingencyTable table) {
        double fMax;
        int numobj = table.contingency[table.size1][table.size2];
        this.smPurity = 0.0;
        this.smFFirst = 0.0;
        for (int i1 = 0; i1 < table.size1; ++i1) {
            double precisionMax = 0.0;
            fMax = 0.0;
            for (int i2 = 0; i2 < table.size2; ++i2) {
                precisionMax = Math.max(precisionMax, 1.0 * (double)table.contingency[i1][i2]);
                fMax = Math.max(fMax, 2.0 * (double)table.contingency[i1][i2] / (double)(table.contingency[i1][table.size2] + table.contingency[table.size1][i2]));
            }
            this.smPurity += precisionMax / (double)numobj;
            this.smFFirst += (double)table.contingency[i1][table.size2] / (double)table.contingency[table.size1][table.size2] * fMax;
        }
        this.smInversePurity = 0.0;
        this.smFSecond = 0.0;
        for (int i2 = 0; i2 < table.size2; ++i2) {
            double recallMax = 0.0;
            fMax = 0.0;
            for (int i1 = 0; i1 < table.size1; ++i1) {
                recallMax = Math.max(recallMax, 1.0 * (double)table.contingency[i1][i2]);
                fMax = Math.max(fMax, 2.0 * (double)table.contingency[i1][i2] / (double)(table.contingency[i1][table.size2] + table.contingency[table.size1][i2]));
            }
            this.smInversePurity += recallMax / (double)numobj;
            this.smFSecond += (double)table.contingency[table.size1][i2] / (double)table.contingency[table.size1][table.size2] * fMax;
        }
    }

    @Reference(authors="Y. Zhao, G. Karypis", title="Criterion functions for document clustering: Experiments and analysis", booktitle="University of Minnesota, Dep. Computer Science, Technical Report 01-40", url="http://www-users.cs.umn.edu/~karypis/publications/Papers/PDF/vscluster.pdf", bibkey="tr/umn/ZhaoK01")
    public double purity() {
        return this.smPurity;
    }

    public double inversePurity() {
        return this.smInversePurity;
    }

    @Reference(authors="M. Steinbach, G. Karypis, V. Kumar", title="A Comparison of Document Clustering Techniques", booktitle="KDD workshop on text mining. Vol. 400. No. 1", url="http://glaros.dtc.umn.edu/gkhome/fetch/papers/docclusterKDDTMW00.pdf", bibkey="conf/kdd/SteinbachKK00")
    public double f1Measure() {
        return ClusterContingencyTable.Util.f1Measure(this.purity(), this.inversePurity());
    }

    @Reference(authors="E. Amig\u00f3, J. Gonzalo, J. Artiles, F. Verdejo", title="A comparison of extrinsic clustering evaluation metrics based on formal constraints", booktitle="Information Retrieval 12(5)", url="https://doi.org/10.1007/s10791-009-9106-z", bibkey="DBLP:journals/ir/AmigoGAV09a")
    public double fMeasureFirst() {
        return this.smFFirst;
    }

    @Reference(authors="E. Amig\u00f3, J. Gonzalo, J. Artiles, F. Verdejo", title="A comparison of extrinsic clustering evaluation metrics based on formal constraints", booktitle="Information Retrieval 12(5)", url="https://doi.org/10.1007/s10791-009-9106-z", bibkey="DBLP:journals/ir/AmigoGAV09a")
    public double fMeasureSecond() {
        return this.smFSecond;
    }
}

