/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering.extractor;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.extraction.CutDendrogramByHeight;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ChainedParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import java.util.ArrayList;

public class CutDendrogramByHeightExtractor
implements Evaluator {
    private CutDendrogramByHeight inner;

    public CutDendrogramByHeightExtractor(CutDendrogramByHeight inner) {
        this.inner = inner;
    }

    @Override
    public void processNewResult(ResultHierarchy hier, Result newResult) {
        ArrayList<PointerHierarchyRepresentationResult> hrs = ResultUtil.filterResults(hier, newResult, PointerHierarchyRepresentationResult.class);
        for (PointerHierarchyRepresentationResult pointerresult : hrs) {
            pointerresult.addChildResult(this.inner.run(pointerresult));
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        CutDendrogramByHeight inner;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            ListParameterization overrides = new ListParameterization();
            overrides.addParameter(AbstractAlgorithm.ALGORITHM_ID, DummyHierarchicalClusteringAlgorithm.class);
            ChainedParameterization list = new ChainedParameterization(overrides, config);
            list.errorsTo(config);
            this.inner = list.tryInstantiate(CutDendrogramByHeight.class);
        }

        @Override
        protected CutDendrogramByHeightExtractor makeInstance() {
            return new CutDendrogramByHeightExtractor(this.inner);
        }
    }

    protected static class DummyHierarchicalClusteringAlgorithm
    implements HierarchicalClusteringAlgorithm {
        @Override
        public TypeInformation[] getInputTypeRestriction() {
            return TypeUtil.array(new TypeInformation[0]);
        }

        @Override
        public PointerHierarchyRepresentationResult run(Database db) {
            throw new AbortException("This must not be called");
        }
    }
}

