/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering.extractor;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.extraction.HDBSCANHierarchyExtraction;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.DendrogramModel;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.evaluation.clustering.extractor.CutDendrogramByHeightExtractor;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ChainedParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import java.util.ArrayList;

public class HDBSCANHierarchyExtractionEvaluator
implements Evaluator {
    private HDBSCANHierarchyExtraction inner;

    public HDBSCANHierarchyExtractionEvaluator(HDBSCANHierarchyExtraction inner) {
        this.inner = inner;
    }

    @Override
    public void processNewResult(ResultHierarchy hier, Result newResult) {
        ArrayList<PointerHierarchyRepresentationResult> hrs = ResultUtil.filterResults(hier, newResult, PointerHierarchyRepresentationResult.class);
        for (PointerHierarchyRepresentationResult pointerresult : hrs) {
            Clustering<DendrogramModel> result = this.inner.run(pointerresult);
            pointerresult.addChildResult(result);
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        HDBSCANHierarchyExtraction inner;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            ListParameterization overrides = new ListParameterization();
            overrides.addParameter(AbstractAlgorithm.ALGORITHM_ID, CutDendrogramByHeightExtractor.DummyHierarchicalClusteringAlgorithm.class);
            ChainedParameterization list = new ChainedParameterization(overrides, config);
            this.inner = (HDBSCANHierarchyExtraction)ClassGenericsUtil.parameterizeOrAbort(HDBSCANHierarchyExtraction.class, list);
        }

        @Override
        protected HDBSCANHierarchyExtractionEvaluator makeInstance() {
            return new HDBSCANHierarchyExtractionEvaluator(this.inner);
        }
    }
}

