/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering.internal;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.evaluation.clustering.internal.NoiseHandling;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.StringStatistic;
import de.lmu.ifi.dbs.elki.result.EvaluationResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.DoubleHeap;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.DoubleMaxHeap;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.DoubleMinHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;

@Reference(authors="L. J. Hubert, J. R. Levin", title="A general statistical framework for assessing categorical clustering in free recall", booktitle="Psychological Bulletin, Vol. 83(6)", url="https://doi.org/10.1037/0033-2909.83.6.1072", bibkey="doi:10.1037/0033-2909.83.6.1072")
public class EvaluateCIndex<O>
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(EvaluateCIndex.class);
    private NoiseHandling noiseOption;
    private DistanceFunction<? super O> distance;
    private String key = EvaluateCIndex.class.getName();

    public EvaluateCIndex(DistanceFunction<? super O> distance, NoiseHandling noiseOpt) {
        this.distance = distance;
        this.noiseOption = noiseOpt;
    }

    /*
     * Unable to fully structure code
     */
    public double evaluateClustering(Database db, Relation<? extends O> rel, DistanceQuery<O> dq, Clustering<?> c) {
        clusters = c.getAllClusters();
        ignorednoise = 0;
        w = 0;
        block9: for (Cluster<?> cluster : clusters) {
            if (cluster.size() <= 1 || cluster.isNoise()) {
                switch (1.$SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling[this.noiseOption.ordinal()]) {
                    case 1: {
                        ignorednoise += cluster.size();
                        continue block9;
                    }
                    case 2: {
                        continue block9;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        EvaluateCIndex.LOG.warning("Unknown noise handling option: " + (Object)this.noiseOption);
                    }
                }
            }
            w += cluster.size() * (cluster.size() - 1) >>> 1;
        }
        maxDists = new DoubleMinHeap(w);
        minDists = new DoubleMaxHeap(w);
        theta = 0.0;
        prog = EvaluateCIndex.LOG.isVerbose() != false ? new FiniteProgress("Processing clusters for C-Index", clusters.size(), EvaluateCIndex.LOG) : null;
        block10: for (i = 0; i < clusters.size(); ++i) {
            cluster = clusters.get(i);
            if (cluster.size() > 1 && !cluster.isNoise()) ** GOTO lbl-1000
            switch (1.$SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling[this.noiseOption.ordinal()]) {
                case 1: {
                    EvaluateCIndex.LOG.incrementProcessed(prog);
                    continue block10;
                }
                case 2: {
                    this.processSingleton(cluster, rel, dq, maxDists, minDists, w);
                    EvaluateCIndex.LOG.incrementProcessed(prog);
                    continue block10;
                }
                default: lbl-1000:
                // 2 sources

                {
                    theta += this.processCluster(cluster, clusters, i, dq, maxDists, minDists, w);
                    EvaluateCIndex.LOG.incrementProcessed(prog);
                }
            }
        }
        EvaluateCIndex.LOG.ensureCompleted(prog);
        min = 0.0;
        max = 0.0;
        if (!EvaluateCIndex.$assertionsDisabled && minDists.size() != w) {
            throw new AssertionError();
        }
        if (!EvaluateCIndex.$assertionsDisabled && maxDists.size() != w) {
            throw new AssertionError();
        }
        it = minDists.unsortedIter();
        while (it.valid()) {
            min += it.get();
            it.advance();
        }
        it = maxDists.unsortedIter();
        while (it.valid()) {
            max += it.get();
            it.advance();
        }
        if (!EvaluateCIndex.$assertionsDisabled && !(max >= min)) {
            throw new AssertionError();
        }
        v0 = cIndex = max > min ? (theta - min) / (max - min) : 1.0;
        if (EvaluateCIndex.LOG.isStatistics()) {
            EvaluateCIndex.LOG.statistics(new StringStatistic(this.key + ".c-index.noise-handling", this.noiseOption.toString()));
            if (ignorednoise > 0) {
                EvaluateCIndex.LOG.statistics(new LongStatistic(this.key + ".c-index.ignored", ignorednoise));
            }
            EvaluateCIndex.LOG.statistics(new DoubleStatistic(this.key + ".c-index", cIndex));
        }
        ev = EvaluationResult.findOrCreate(db.getHierarchy(), c, "Internal Clustering Evaluation", "internal evaluation");
        g = ev.findOrCreateGroup("Distance-based Evaluation");
        g.addMeasure("C-Index", cIndex, 0.0, 1.0, 0.0, true);
        db.getHierarchy().resultChanged(ev);
        return cIndex;
    }

    /*
     * Unable to fully structure code
     */
    protected double processCluster(Cluster<?> cluster, List<? extends Cluster<?>> clusters, int i, DistanceQuery<O> dq, DoubleHeap maxDists, DoubleHeap minDists, int w) {
        theta = 0.0;
        it1 = cluster.getIDs().iter();
        while (it1.valid()) {
            block5: for (j = i; j < clusters.size(); ++j) {
                ocluster = clusters.get(j);
                if (ocluster.size() > 1 && !ocluster.isNoise()) ** GOTO lbl-1000
                switch (1.$SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling[this.noiseOption.ordinal()]) {
                    case 1: {
                        continue block5;
                    }
                    ** case 2:
lbl11:
                    // 2 sources

                    default: lbl-1000:
                    // 2 sources

                    {
                        it2 = ocluster.getIDs().iter();
                        while (it2.valid()) {
                            if (DBIDUtil.compare(it1, it2) > 0) {
                                dist = dq.distance((DBIDRef)it1, (DBIDRef)it2);
                                minDists.add(dist, w);
                                maxDists.add(dist, w);
                                if (ocluster == cluster) {
                                    theta += dist;
                                }
                            }
                            it2.advance();
                        }
                        break block0;
                    }
                }
            }
            it1.advance();
        }
        return theta;
    }

    protected void processSingleton(Cluster<?> cluster, Relation<? extends O> rel, DistanceQuery<O> dq, DoubleHeap maxDists, DoubleHeap minDists, int w) {
        DBIDIter it1 = cluster.getIDs().iter();
        while (it1.valid()) {
            DBIDIter it2 = rel.iterDBIDs();
            while (it2.valid()) {
                if (DBIDUtil.compare(it1, it2) > 0) {
                    double dist = dq.distance((DBIDRef)it1, (DBIDRef)it2);
                    minDists.add(dist, w);
                    maxDists.add(dist, w);
                }
                it2.advance();
            }
            it1.advance();
        }
    }

    @Override
    public void processNewResult(ResultHierarchy hier, Result result) {
        List<Clustering<Model>> crs = Clustering.getClusteringResults(result);
        if (crs.size() < 1) {
            return;
        }
        Database db = ResultUtil.findDatabase(hier);
        Relation rel = db.getRelation(this.distance.getInputTypeRestriction(), new Object[0]);
        DistanceQuery<? super O> dq = db.getDistanceQuery(rel, this.distance, new Object[0]);
        for (Clustering<Model> c : crs) {
            this.evaluateClustering(db, rel, dq, c);
        }
    }

    public static class Parameterizer<O>
    extends AbstractParameterizer {
        public static final OptionID DISTANCE_ID = new OptionID("c-index.distance", "Distance function to use for computing the c-index.");
        public static final OptionID NOISE_ID = new OptionID("c-index.noisehandling", "Control how noise should be treated.");
        private DistanceFunction<? super O> distance;
        private NoiseHandling noiseOption;

        @Override
        protected void makeOptions(Parameterization config) {
            EnumParameter<NoiseHandling> noiseP;
            super.makeOptions(config);
            ObjectParameter distanceFunctionP = new ObjectParameter(DISTANCE_ID, (Class<?>)DistanceFunction.class, EuclideanDistanceFunction.class);
            if (config.grab(distanceFunctionP)) {
                this.distance = (DistanceFunction)distanceFunctionP.instantiateClass(config);
            }
            if (config.grab(noiseP = new EnumParameter<NoiseHandling>(NOISE_ID, NoiseHandling.class, NoiseHandling.TREAT_NOISE_AS_SINGLETONS))) {
                this.noiseOption = (NoiseHandling)((Object)noiseP.getValue());
            }
        }

        @Override
        protected EvaluateCIndex<O> makeInstance() {
            return new EvaluateCIndex<O>(this.distance, this.noiseOption);
        }
    }
}

