/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering.internal;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.evaluation.clustering.internal.NoiseHandling;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.StringStatistic;
import de.lmu.ifi.dbs.elki.result.EvaluationResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.Arrays;
import java.util.List;
import net.jafama.FastMath;

@Reference(authors="F. B. Baker, L. J. Hubert", title="Measuring the Power of Hierarchical Cluster Analysis", booktitle="Journal of the American Statistical Association, 70(349)", url="https://doi.org/10.1080/01621459.1975.10480256", bibkey="doi:10.1080/01621459.1975.10480256")
public class EvaluateConcordantPairs<O>
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(EvaluateConcordantPairs.class);
    private NoiseHandling noiseHandling;
    private PrimitiveDistanceFunction<? super NumberVector> distanceFunction;
    private String key = EvaluateConcordantPairs.class.getName();

    public EvaluateConcordantPairs(PrimitiveDistanceFunction<? super NumberVector> distance, NoiseHandling noiseHandling) {
        this.distanceFunction = distance;
        this.noiseHandling = noiseHandling;
    }

    public double evaluateClustering(Database db, Relation<? extends NumberVector> rel, Clustering<?> c) {
        List<Cluster<?>> clusters = c.getAllClusters();
        int ignorednoise = 0;
        int withinPairs = 0;
        block4: for (Cluster<?> cluster : clusters) {
            if (cluster.size() <= 1 || cluster.isNoise()) {
                switch (this.noiseHandling) {
                    case IGNORE_NOISE: {
                        ignorednoise += cluster.size();
                        continue block4;
                    }
                    case TREAT_NOISE_AS_SINGLETONS: {
                        continue block4;
                    }
                }
            }
            if ((withinPairs += cluster.size() * (cluster.size() - 1) >>> 1) >= 0) continue;
            throw new AbortException("Integer overflow - clusters too large to compute pairwise distances.");
        }
        double[] withinDistances = this.computeWithinDistances(rel, clusters, withinPairs);
        int[] withinTies = new int[withinDistances.length];
        this.countTies(withinDistances, withinTies);
        long concordantPairs = 0L;
        long discordantPairs = 0L;
        long betweenPairs = 0L;
        for (int i = 0; i < clusters.size(); ++i) {
            Cluster<?> ocluster1 = clusters.get(i);
            if ((ocluster1.size() <= 1 || ocluster1.isNoise()) && this.noiseHandling.equals((Object)NoiseHandling.IGNORE_NOISE)) continue;
            for (int j = i + 1; j < clusters.size(); ++j) {
                Cluster<?> ocluster2 = clusters.get(j);
                if ((ocluster2.size() <= 1 || ocluster2.isNoise()) && this.noiseHandling.equals((Object)NoiseHandling.IGNORE_NOISE)) continue;
                betweenPairs += (long)ocluster1.size() * (long)ocluster2.size();
                DBIDIter oit1 = ocluster1.getIDs().iter();
                while (oit1.valid()) {
                    NumberVector obj = rel.get(oit1);
                    DBIDIter oit2 = ocluster2.getIDs().iter();
                    while (oit2.valid()) {
                        double dist = this.distanceFunction.distance(obj, rel.get(oit2));
                        int p = Arrays.binarySearch(withinDistances, dist);
                        if (p >= 0) {
                            while (p > 0 && withinDistances[p - 1] >= dist) {
                                --p;
                            }
                            concordantPairs += (long)p;
                            discordantPairs += (long)(withinDistances.length - p - withinTies[p]);
                        } else {
                            p = -p - 1;
                            concordantPairs += (long)p;
                            discordantPairs += (long)(withinDistances.length - p);
                        }
                        oit2.advance();
                    }
                    oit1.advance();
                }
            }
        }
        long t = (long)(rel.size() - ignorednoise) * (long)(rel.size() - ignorednoise - 1) >>> 1;
        long tt = t * (t - 1L) >>> 1;
        double gamma = (double)(concordantPairs - discordantPairs) / (double)(concordantPairs + discordantPairs);
        double tau = this.computeTau(concordantPairs, discordantPairs, tt, withinDistances.length, betweenPairs);
        gamma = gamma > 0.0 ? gamma : 0.0;
        double d = tau = tau > 0.0 ? tau : 0.0;
        if (LOG.isStatistics()) {
            LOG.statistics(new StringStatistic(this.key + ".noise-handling", this.noiseHandling.toString()));
            if (ignorednoise > 0) {
                LOG.statistics(new LongStatistic(this.key + ".ignored", ignorednoise));
            }
            LOG.statistics(new DoubleStatistic(this.key + ".gamma", gamma));
            LOG.statistics(new DoubleStatistic(this.key + ".tau", tau));
        }
        EvaluationResult ev = EvaluationResult.findOrCreate(db.getHierarchy(), c, "Internal Clustering Evaluation", "internal evaluation");
        EvaluationResult.MeasurementGroup g = ev.findOrCreateGroup("Concordance-based Evaluation");
        g.addMeasure("Gamma", gamma, -1.0, 1.0, 0.0, false);
        g.addMeasure("Tau", tau, -1.0, 1.0, 0.0, false);
        db.getHierarchy().resultChanged(ev);
        return gamma;
    }

    protected int countTies(double[] withinDistances, int[] withinTies) {
        int wties = 0;
        int running = 1;
        for (int i = 1; i <= withinDistances.length; ++i) {
            if (i == withinDistances.length || withinDistances[i - 1] != withinDistances[i]) {
                for (int j = i - running; j < i; ++j) {
                    withinTies[j] = running;
                }
                wties += running - 1;
                running = 1;
                continue;
            }
            ++running;
        }
        return wties;
    }

    protected double[] computeWithinDistances(Relation<? extends NumberVector> rel, List<? extends Cluster<?>> clusters, int withinPairs) {
        double[] concordant = new double[withinPairs];
        int i = 0;
        block4: for (Cluster<?> cluster : clusters) {
            if (cluster.size() <= 1 || cluster.isNoise()) {
                switch (this.noiseHandling) {
                    case IGNORE_NOISE: {
                        continue block4;
                    }
                    case TREAT_NOISE_AS_SINGLETONS: {
                        continue block4;
                    }
                }
            }
            DBIDIter it1 = cluster.getIDs().iter();
            while (it1.valid()) {
                NumberVector obj = rel.get(it1);
                DBIDIter it2 = cluster.getIDs().iter();
                while (it2.valid()) {
                    if (DBIDUtil.compare(it1, it2) > 0) {
                        concordant[i++] = this.distanceFunction.distance(obj, rel.get(it2));
                    }
                    it2.advance();
                }
                it1.advance();
            }
        }
        assert (concordant.length == i);
        Arrays.sort(concordant);
        return concordant;
    }

    @Reference(authors="F. J. Rohlf", title="Methods of comparing classifications", booktitle="Annual Review of Ecology and Systematics", url="https://doi.org/10.1146/annurev.es.05.110174.000533", bibkey="doi:10.1146/annurev.es.05.110174.000533")
    public double computeTau(long c, long d, double m, long wd, long bd) {
        double tie = wd * (wd - 1L) + bd * (bd - 1L) >>> 1;
        return (double)(c - d) / FastMath.sqrt((m - tie) * m);
    }

    @Override
    public void processNewResult(ResultHierarchy hier, Result result) {
        List<Clustering<Model>> crs = Clustering.getClusteringResults(result);
        if (crs.isEmpty()) {
            return;
        }
        Database db = ResultUtil.findDatabase(hier);
        Relation rel = db.getRelation(this.distanceFunction.getInputTypeRestriction(), new Object[0]);
        for (Clustering<Model> c : crs) {
            this.evaluateClustering(db, rel, c);
        }
    }

    public static class Parameterizer<O>
    extends AbstractParameterizer {
        public static final OptionID DISTANCE_ID = new OptionID("concordant.distance", "Distance function to use for measuring concordant and discordant pairs.");
        public static final OptionID NOISE_ID = new OptionID("concordant-pairs.noisehandling", "Control how noise should be treated.");
        private PrimitiveDistanceFunction<NumberVector> distance;
        private NoiseHandling noiseHandling;

        @Override
        protected void makeOptions(Parameterization config) {
            EnumParameter<NoiseHandling> noiseP;
            super.makeOptions(config);
            ObjectParameter distanceFunctionP = new ObjectParameter(DISTANCE_ID, (Class<?>)PrimitiveDistanceFunction.class, EuclideanDistanceFunction.class);
            if (config.grab(distanceFunctionP)) {
                this.distance = (PrimitiveDistanceFunction)distanceFunctionP.instantiateClass(config);
            }
            if (config.grab(noiseP = new EnumParameter<NoiseHandling>(NOISE_ID, NoiseHandling.class, NoiseHandling.TREAT_NOISE_AS_SINGLETONS))) {
                this.noiseHandling = (NoiseHandling)((Object)noiseP.getValue());
            }
        }

        @Override
        protected EvaluateConcordantPairs<O> makeInstance() {
            return new EvaluateConcordantPairs(this.distance, this.noiseHandling);
        }
    }
}

