/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering.internal;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.type.CombinedTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.geometry.PrimsMinimumSpanningTree;
import de.lmu.ifi.dbs.elki.result.EvaluationResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;
import net.jafama.FastMath;

@Reference(authors="Davoud Moulavi, Pablo A. Jaskowiak, Ricardo J. G. B. Campello, Arthur Zimek, J\u00f6rg Sander", title="Density-Based Clustering Validation", booktitle="Proc. 14th SIAM International Conference on Data Mining (SDM)", url="https://doi.org/10.1137/1.9781611973440.96", bibkey="DBLP:conf/sdm/MoulaviJCZS14")
public class EvaluateDBCV<O>
implements Evaluator {
    private DistanceFunction<? super O> distanceFunction;

    public EvaluateDBCV(DistanceFunction<? super O> distance) {
        this.distanceFunction = distance;
    }

    public double evaluateClustering(Database db, Relation<O> rel, Clustering<?> cl) {
        DistanceQuery<O> dq = rel.getDistanceQuery(this.distanceFunction, new Object[0]);
        List<Cluster<?>> clusters = cl.getAllClusters();
        int numc = clusters.size();
        Relation<O> vrel = rel;
        int dim = RelationUtil.dimensionality(vrel);
        ArrayDBIDs[] cids = new ArrayDBIDs[numc];
        double[][] coreDists = new double[numc][];
        for (int c = 0; c < numc; ++c) {
            Cluster<?> cluster = clusters.get(c);
            if (cluster.isNoise() || cluster.size() < 2) {
                coreDists[c] = null;
                continue;
            }
            ArrayDBIDs ids = cids[c] = DBIDUtil.ensureArray(cluster.getIDs());
            coreDists[c] = new double[ids.size()];
            double[] clusterCoreDists = coreDists[c];
            DBIDArrayIter it = ids.iter();
            DBIDArrayIter it2 = ids.iter();
            while (it.valid()) {
                double currentCoreDist = 0.0;
                int neighbors = 0;
                it2.seek(0);
                while (it2.valid()) {
                    double dist;
                    if (!DBIDUtil.equal(it, it2) && (dist = dq.distance((DBIDRef)it, (DBIDRef)it2)) > 0.0) {
                        currentCoreDist += MathUtil.powi(1.0 / dist, dim);
                        ++neighbors;
                    }
                    it2.advance();
                }
                clusterCoreDists[it.getOffset()] = FastMath.pow(currentCoreDist / (double)neighbors, -1.0 / (double)dim);
                it.advance();
            }
        }
        int[][] clusterDegrees = new int[numc][];
        double[] clusterDscMax = new double[numc];
        boolean[] internalEdges = new boolean[numc];
        for (int c = 0; c < numc; ++c) {
            int i;
            Cluster<?> cluster = clusters.get(c);
            if (cluster.isNoise() || cluster.size() < 2) {
                clusterDegrees[c] = null;
                clusterDscMax[c] = Double.NaN;
                continue;
            }
            double[] clusterCoreDists = coreDists[c];
            ArrayDBIDs ids = cids[c];
            double dscMax = 0.0;
            double[][] distances = new double[cluster.size()][cluster.size()];
            DBIDArrayIter it = ids.iter();
            DBIDArrayIter it2 = ids.iter();
            while (it.valid()) {
                double currentCoreDist = clusterCoreDists[it.getOffset()];
                it2.seek(it.getOffset() + 1);
                while (it2.valid()) {
                    double mutualReachDist;
                    distances[it.getOffset()][it2.getOffset()] = mutualReachDist = MathUtil.max(currentCoreDist, clusterCoreDists[it2.getOffset()], dq.distance((DBIDRef)it, (DBIDRef)it2));
                    distances[it2.getOffset()][it.getOffset()] = mutualReachDist;
                    it2.advance();
                }
                it.advance();
            }
            int[] nodes = PrimsMinimumSpanningTree.processDense(distances);
            int[] degree = new int[cluster.size()];
            for (i = 0; i < nodes.length; ++i) {
                int n = nodes[i];
                degree[n] = degree[n] + 1;
            }
            int e = nodes.length - 1;
            for (i = 0; i < e; i += 2) {
                if (degree[nodes[i]] <= 1 || degree[nodes[i + 1]] <= 1) continue;
                internalEdges[c] = true;
            }
            clusterDegrees[c] = degree;
            e = nodes.length - 1;
            for (i = 0; i < e; i += 2) {
                int n1 = nodes[i];
                int n2 = nodes[i + 1];
                if (!(distances[n1][n2] > dscMax) || internalEdges[c] && (degree[n1] <= 1 || degree[n2] <= 1)) continue;
                dscMax = distances[n1][n2];
            }
            clusterDscMax[c] = dscMax;
        }
        double dbcv = 0.0;
        for (int c = 0; c < numc; ++c) {
            Cluster<?> cluster = clusters.get(c);
            if (cluster.isNoise() || cluster.size() < 2) continue;
            double currentDscMax = clusterDscMax[c];
            double[] clusterCoreDists = coreDists[c];
            int[] currentDegree = clusterDegrees[c];
            double dspcMin = Double.POSITIVE_INFINITY;
            DBIDArrayIter it = cids[c].iter();
            while (it.valid()) {
                if (currentDegree[it.getOffset()] >= 2 || !internalEdges[c]) {
                    double currentCoreDist = clusterCoreDists[it.getOffset()];
                    for (int oc = 0; oc < numc; ++oc) {
                        Cluster<?> ocluster = clusters.get(oc);
                        if (ocluster.isNoise() || ocluster.size() < 2 || cluster == ocluster) continue;
                        int[] oDegree = clusterDegrees[oc];
                        double[] oclusterCoreDists = coreDists[oc];
                        DBIDArrayIter it2 = cids[oc].iter();
                        while (it2.valid()) {
                            if (oDegree[it2.getOffset()] >= 2 || !internalEdges[oc]) {
                                double mutualReachDist = MathUtil.max(currentCoreDist, oclusterCoreDists[it2.getOffset()], dq.distance((DBIDRef)it, (DBIDRef)it2));
                                dspcMin = mutualReachDist < dspcMin ? mutualReachDist : dspcMin;
                            }
                            it2.advance();
                        }
                    }
                }
                it.advance();
            }
            double vc = (dspcMin - currentDscMax) / MathUtil.max(dspcMin, currentDscMax);
            double weight = (double)cluster.size() / (double)rel.size();
            dbcv += weight * vc;
        }
        EvaluationResult ev = EvaluationResult.findOrCreate(db.getHierarchy(), cl, "Internal Clustering Evaluation", "internal evaluation");
        EvaluationResult.MeasurementGroup g = ev.findOrCreateGroup("Distance-based Evaluation");
        g.addMeasure("Density Based Clustering Validation", dbcv, 0.0, Double.POSITIVE_INFINITY, 0.0, true);
        db.getHierarchy().resultChanged(ev);
        return dbcv;
    }

    @Override
    public void processNewResult(ResultHierarchy hier, Result newResult) {
        List<Clustering<Model>> crs = Clustering.getClusteringResults(newResult);
        if (crs.size() < 1) {
            return;
        }
        Database db = ResultUtil.findDatabase(hier);
        CombinedTypeInformation typ = new CombinedTypeInformation(this.distanceFunction.getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD);
        Relation rel = db.getRelation(typ, new Object[0]);
        if (rel != null) {
            for (Clustering<Model> cl : crs) {
                this.evaluateClustering(db, rel, cl);
            }
        }
    }

    public static class Parameterizer<O>
    extends AbstractParameterizer {
        public static final OptionID DISTANCE_ID = new OptionID("dbcv.distance", "Distance function to use for computing the dbcv.");
        private DistanceFunction<? super O> distance;

        @Override
        protected void makeOptions(Parameterization config) {
            ObjectParameter distanceFunctionP = new ObjectParameter(DISTANCE_ID, (Class<?>)DistanceFunction.class, EuclideanDistanceFunction.class);
            if (config.grab(distanceFunctionP)) {
                this.distance = (DistanceFunction)distanceFunctionP.instantiateClass(config);
            }
        }

        @Override
        protected EvaluateDBCV<O> makeInstance() {
            return new EvaluateDBCV<O>(this.distance);
        }
    }
}

