/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering.internal;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.evaluation.clustering.internal.EvaluateSimplifiedSilhouette;
import de.lmu.ifi.dbs.elki.evaluation.clustering.internal.NoiseHandling;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.StringStatistic;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.result.EvaluationResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.Iterator;
import java.util.List;

@Reference(authors="D. L. Davies, D. W. Bouldin", title="A Cluster Separation Measure", booktitle="IEEE Transactions Pattern Analysis and Machine Intelligence 1(2)", url="https://doi.org/10.1109/TPAMI.1979.4766909", bibkey="DBLP:journals/pami/DaviesB79")
public class EvaluateDaviesBouldin
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(EvaluateDaviesBouldin.class);
    private NoiseHandling noiseOption;
    private NumberVectorDistanceFunction<?> distanceFunction;
    private String key = EvaluateDaviesBouldin.class.getName();

    public EvaluateDaviesBouldin(NumberVectorDistanceFunction<?> distance, NoiseHandling noiseOpt) {
        this.distanceFunction = distance;
        this.noiseOption = noiseOpt;
    }

    public double evaluateClustering(Database db, Relation<? extends NumberVector> rel, Clustering<?> c) {
        double daviesBouldinMean;
        List<Cluster<?>> clusters = c.getAllClusters();
        NumberVector[] centroids = new NumberVector[clusters.size()];
        int noisecount = EvaluateSimplifiedSilhouette.centroids(rel, clusters, centroids, this.noiseOption);
        double[] withinGroupDistance = this.withinGroupDistances(rel, clusters, centroids);
        Mean daviesBouldin = new Mean();
        for (int i = 0; i < clusters.size(); ++i) {
            NumberVector centroid = centroids[i];
            double withinGroupDistancei = withinGroupDistance[i];
            double max = 0.0;
            for (int j = 0; j < clusters.size(); ++j) {
                double d2;
                double d;
                NumberVector ocentroid = centroids[j];
                if (ocentroid == centroid) continue;
                if (centroid != null && ocentroid != null) {
                    double bD = this.distanceFunction.distance(centroid, ocentroid);
                    double d3 = (withinGroupDistancei + withinGroupDistance[j]) / bD;
                    max = d3 > max ? d3 : max;
                    continue;
                }
                if (this.noiseOption == NoiseHandling.IGNORE_NOISE) continue;
                if (centroid != null) {
                    d = Double.POSITIVE_INFINITY;
                    DBIDIter it = clusters.get(j).getIDs().iter();
                    while (it.valid()) {
                        d2 = this.distanceFunction.distance(centroid, rel.get(it));
                        d = d2 < d ? d2 : d;
                        it.advance();
                    }
                    max = (d = withinGroupDistancei / d) > max ? d : max;
                    continue;
                }
                if (ocentroid == null) continue;
                d = Double.POSITIVE_INFINITY;
                DBIDIter it = clusters.get(i).getIDs().iter();
                while (it.valid()) {
                    d2 = this.distanceFunction.distance(rel.get(it), ocentroid);
                    d = d2 < d ? d2 : d;
                    it.advance();
                }
                max = (d = withinGroupDistance[j] / d) > max ? d : max;
            }
            daviesBouldin.put(max);
        }
        double d = daviesBouldinMean = daviesBouldin.getCount() > 1.0 ? daviesBouldin.getMean() : 2.0;
        if (LOG.isStatistics()) {
            LOG.statistics(new StringStatistic(this.key + ".db-index.noise-handling", this.noiseOption.toString()));
            if (noisecount > 0) {
                LOG.statistics(new LongStatistic(this.key + ".db-index.ignored", noisecount));
            }
            LOG.statistics(new DoubleStatistic(this.key + ".db-index", daviesBouldinMean));
        }
        EvaluationResult ev = EvaluationResult.findOrCreate(db.getHierarchy(), c, "Internal Clustering Evaluation", "internal evaluation");
        EvaluationResult.MeasurementGroup g = ev.findOrCreateGroup("Distance-based Evaluation");
        g.addMeasure("Davies Bouldin Index", daviesBouldinMean, 0.0, Double.POSITIVE_INFINITY, 0.0, true);
        db.getHierarchy().resultChanged(ev);
        return daviesBouldinMean;
    }

    public double[] withinGroupDistances(Relation<? extends NumberVector> rel, List<? extends Cluster<?>> clusters, NumberVector[] centroids) {
        double[] withinGroupDists = new double[clusters.size()];
        Iterator<Cluster<?>> ci = clusters.iterator();
        int i = 0;
        while (ci.hasNext()) {
            Cluster<?> cluster = ci.next();
            NumberVector centroid = centroids[i];
            if (centroid == null) {
                withinGroupDists[i] = 0.0;
            } else {
                double wD = 0.0;
                DBIDIter it = cluster.getIDs().iter();
                while (it.valid()) {
                    wD += this.distanceFunction.distance(centroid, rel.get(it));
                    it.advance();
                }
                withinGroupDists[i] = wD / (double)cluster.size();
            }
            ++i;
        }
        return withinGroupDists;
    }

    @Override
    public void processNewResult(ResultHierarchy hier, Result result) {
        List<Clustering<Model>> crs = Clustering.getClusteringResults(result);
        if (crs.isEmpty()) {
            return;
        }
        Database db = ResultUtil.findDatabase(hier);
        Relation rel = db.getRelation(this.distanceFunction.getInputTypeRestriction(), new Object[0]);
        for (Clustering<Model> c : crs) {
            this.evaluateClustering(db, rel, c);
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID DISTANCE_ID = new OptionID("davies-bouldin.distance", "Distance function to use for computing the davies-bouldin index.");
        public static final OptionID NOISE_ID = new OptionID("davies-bouldin.noisehandling", "Control how noise should be treated.");
        private NumberVectorDistanceFunction<?> distance;
        private NoiseHandling noiseOption;

        @Override
        protected void makeOptions(Parameterization config) {
            EnumParameter<NoiseHandling> noiseP;
            super.makeOptions(config);
            ObjectParameter distanceFunctionP = new ObjectParameter(DISTANCE_ID, (Class<?>)NumberVectorDistanceFunction.class, EuclideanDistanceFunction.class);
            if (config.grab(distanceFunctionP)) {
                this.distance = (NumberVectorDistanceFunction)distanceFunctionP.instantiateClass(config);
            }
            if (config.grab(noiseP = new EnumParameter<NoiseHandling>(NOISE_ID, NoiseHandling.class, NoiseHandling.TREAT_NOISE_AS_SINGLETONS))) {
                this.noiseOption = (NoiseHandling)((Object)noiseP.getValue());
            }
        }

        @Override
        protected EvaluateDaviesBouldin makeInstance() {
            return new EvaluateDaviesBouldin(this.distance, this.noiseOption);
        }
    }
}

