/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering.internal;

import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.evaluation.clustering.internal.EvaluateSimplifiedSilhouette;
import de.lmu.ifi.dbs.elki.evaluation.clustering.internal.EvaluateVarianceRatioCriteria;
import de.lmu.ifi.dbs.elki.evaluation.clustering.internal.NoiseHandling;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.StringStatistic;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Centroid;
import de.lmu.ifi.dbs.elki.result.EvaluationResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;
import net.jafama.FastMath;

@Reference(authors="M. K. Pakhira, S. Bandyopadhyay, U. Maulik", title="Validity index for crisp and fuzzy clusters", booktitle="Pattern recognition, 37(3)", url="https://doi.org/10.1016/j.patcog.2003.06.005", bibkey="DBLP:journals/pr/PakhiraBM04")
public class EvaluatePBMIndex
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(EvaluatePBMIndex.class);
    private NoiseHandling noiseHandling;
    private NumberVectorDistanceFunction<?> distanceFunction;
    private String key = EvaluatePBMIndex.class.getName();

    public EvaluatePBMIndex(NumberVectorDistanceFunction<?> distance, NoiseHandling noiseOpt) {
        this.distanceFunction = distance;
        this.noiseHandling = noiseOpt;
    }

    /*
     * Unable to fully structure code
     */
    public double evaluateClustering(Database db, Relation<? extends NumberVector> rel, Clustering<?> c) {
        clusters = c.getAllClusters();
        centroids = new NumberVector[clusters.size()];
        ignorednoise = EvaluateSimplifiedSilhouette.centroids(rel, clusters, centroids, this.noiseHandling);
        dim = RelationUtil.dimensionality(rel);
        overallCentroid = new Centroid(dim);
        EvaluateVarianceRatioCriteria.globalCentroid(overallCentroid, rel, clusters, centroids, this.noiseHandling);
        max = 0.0;
        for (i = 0; i < centroids.length; ++i) {
            if (centroids[i] == null && this.noiseHandling != NoiseHandling.TREAT_NOISE_AS_SINGLETONS) continue;
            for (j = i + 1; j < centroids.length; ++j) {
                if (centroids[j] == null && this.noiseHandling != NoiseHandling.TREAT_NOISE_AS_SINGLETONS) continue;
                if (centroids[i] == null && centroids[j] == null) {
                    iti = clusters.get(i).getIDs().iter();
                    while (iti.valid()) {
                        itj = clusters.get(j).getIDs().iter();
                        while (itj.valid()) {
                            dist = this.distanceFunction.distance(rel.get(iti), rel.get(itj));
                            max = dist > max ? dist : max;
                            itj.advance();
                        }
                        iti.advance();
                    }
                    continue;
                }
                if (centroids[i] == null) {
                    iti = clusters.get(i).getIDs().iter();
                    while (iti.valid()) {
                        dist = this.distanceFunction.distance(rel.get(iti), centroids[j]);
                        max = dist > max ? dist : max;
                        iti.advance();
                    }
                    continue;
                }
                if (centroids[j] == null) {
                    itj = clusters.get(j).getIDs().iter();
                    while (itj.valid()) {
                        dist = this.distanceFunction.distance(centroids[i], rel.get(itj));
                        max = dist > max ? dist : max;
                        itj.advance();
                    }
                    continue;
                }
                dist = this.distanceFunction.distance(centroids[i], centroids[j]);
                max = dist > max ? dist : max;
            }
        }
        a = 0.0;
        b = 0.0;
        ci = clusters.iterator();
        i = 0;
        while (ci.hasNext()) {
            cluster = ci.next();
            if (cluster.size() > 1 && !cluster.isNoise()) ** GOTO lbl-1000
            switch (1.$SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling[this.noiseHandling.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    it = cluster.getIDs().iter();
                    while (it.valid()) {
                        b += SquaredEuclideanDistanceFunction.STATIC.distance(overallCentroid, rel.get(it));
                        it.advance();
                    }
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    it = cluster.getIDs().iter();
                    while (it.valid()) {
                        obj = rel.get(it);
                        a += this.distanceFunction.distance(centroids[i], obj);
                        b += this.distanceFunction.distance(overallCentroid, obj);
                        it.advance();
                    }
                    break block0;
                }
            }
            ++i;
        }
        pbm = FastMath.pow(1.0 / (double)centroids.length * (b / a) * max, 2.0);
        if (EvaluatePBMIndex.LOG.isStatistics()) {
            EvaluatePBMIndex.LOG.statistics(new StringStatistic(this.key + ".pbm.noise-handling", this.noiseHandling.toString()));
            if (ignorednoise > 0) {
                EvaluatePBMIndex.LOG.statistics(new LongStatistic(this.key + ".pbm.ignored", ignorednoise));
            }
            EvaluatePBMIndex.LOG.statistics(new DoubleStatistic(this.key + ".pbm", pbm));
        }
        ev = EvaluationResult.findOrCreate(db.getHierarchy(), c, "Internal Clustering Evaluation", "internal evaluation");
        g = ev.findOrCreateGroup("Distance-based Evaluation");
        g.addMeasure("PBM-Index", pbm, 0.0, Infinity, 0.0, false);
        db.getHierarchy().resultChanged(ev);
        return pbm;
    }

    @Override
    public void processNewResult(ResultHierarchy hier, Result result) {
        List<Clustering<Model>> crs = Clustering.getClusteringResults(result);
        if (crs.isEmpty()) {
            return;
        }
        Database db = ResultUtil.findDatabase(hier);
        Relation rel = db.getRelation(this.distanceFunction.getInputTypeRestriction(), new Object[0]);
        for (Clustering<Model> c : crs) {
            this.evaluateClustering(db, rel, c);
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID DISTANCE_ID = new OptionID("pbm.distance", "Distance function to use for computing PBM.");
        public static final OptionID NOISE_ID = new OptionID("pbm.noisehandling", "Control how noise should be treated.");
        private NumberVectorDistanceFunction<?> distance;
        private NoiseHandling noiseHandling;

        @Override
        protected void makeOptions(Parameterization config) {
            EnumParameter<NoiseHandling> noiseP;
            super.makeOptions(config);
            ObjectParameter distanceFunctionP = new ObjectParameter(DISTANCE_ID, (Class<?>)NumberVectorDistanceFunction.class, EuclideanDistanceFunction.class);
            if (config.grab(distanceFunctionP)) {
                this.distance = (NumberVectorDistanceFunction)distanceFunctionP.instantiateClass(config);
            }
            if (config.grab(noiseP = new EnumParameter<NoiseHandling>(NOISE_ID, NoiseHandling.class, NoiseHandling.TREAT_NOISE_AS_SINGLETONS))) {
                this.noiseHandling = (NoiseHandling)((Object)noiseP.getValue());
            }
        }

        @Override
        protected EvaluatePBMIndex makeInstance() {
            return new EvaluatePBMIndex(this.distance, this.noiseHandling);
        }
    }
}

