/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering.internal;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.evaluation.clustering.internal.NoiseHandling;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.StringStatistic;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.EvaluationResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;

@Reference(authors="P. J. Rousseeuw", title="Silhouettes: A graphical aid to the interpretation and validation of cluster analysis", booktitle="Journal of Computational and Applied Mathematics, Volume 20", url="https://doi.org/10.1016/0377-0427(87)90125-7", bibkey="doi:10.1016/0377-04278790125-7")
public class EvaluateSilhouette<O>
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(EvaluateSilhouette.class);
    private DistanceFunction<? super O> distance;
    private NoiseHandling noiseOption;
    private boolean penalize = true;
    private String key = EvaluateSilhouette.class.getName();

    public EvaluateSilhouette(DistanceFunction<? super O> distance, NoiseHandling noiseOption, boolean penalize) {
        this.distance = distance;
        this.noiseOption = noiseOption;
        this.penalize = penalize;
    }

    public EvaluateSilhouette(DistanceFunction<? super O> distance, boolean mergenoise) {
        this(distance, mergenoise ? NoiseHandling.MERGE_NOISE : NoiseHandling.TREAT_NOISE_AS_SINGLETONS, true);
    }

    public double evaluateClustering(Database db, Relation<O> rel, DistanceQuery<O> dq, Clustering<?> c) {
        List<Cluster<?>> clusters = c.getAllClusters();
        MeanVariance msil = new MeanVariance();
        int ignorednoise = 0;
        block8: for (Cluster<?> cluster : clusters) {
            if (cluster.size() <= 1 || cluster.isNoise()) {
                switch (this.noiseOption) {
                    case IGNORE_NOISE: {
                        ignorednoise += cluster.size();
                        continue block8;
                    }
                    case TREAT_NOISE_AS_SINGLETONS: {
                        msil.put(0.0, cluster.size());
                        continue block8;
                    }
                }
            }
            ArrayDBIDs ids = DBIDUtil.ensureArray(cluster.getIDs());
            double[] as = new double[ids.size()];
            DBIDArrayIter it1 = ids.iter();
            DBIDArrayIter it2 = ids.iter();
            it1.seek(0);
            while (it1.valid()) {
                double a = as[it1.getOffset()];
                it2.seek(it1.getOffset() + 1);
                while (it2.valid()) {
                    double dist = dq.distance((DBIDRef)it1, (DBIDRef)it2);
                    a += dist;
                    int n = it2.getOffset();
                    as[n] = as[n] + dist;
                    it2.advance();
                }
                a /= (double)(ids.size() - 1);
                double b = Double.POSITIVE_INFINITY;
                block11: for (Cluster<?> ocluster : clusters) {
                    if (ocluster == cluster) continue;
                    if (ocluster.size() <= 1 || ocluster.isNoise()) {
                        switch (this.noiseOption) {
                            case IGNORE_NOISE: {
                                continue block11;
                            }
                            case TREAT_NOISE_AS_SINGLETONS: {
                                DBIDIter it3 = ocluster.getIDs().iter();
                                while (it3.valid()) {
                                    double dist = dq.distance((DBIDRef)it1, (DBIDRef)it3);
                                    b = dist < b ? dist : b;
                                    it3.advance();
                                }
                                continue block11;
                            }
                        }
                    }
                    DBIDs oids = ocluster.getIDs();
                    double btmp = 0.0;
                    DBIDIter it3 = oids.iter();
                    while (it3.valid()) {
                        btmp += dq.distance((DBIDRef)it1, (DBIDRef)it3);
                        it3.advance();
                    }
                    b = (btmp /= (double)oids.size()) < b ? btmp : b;
                }
                b = b < Double.POSITIVE_INFINITY ? b : a;
                msil.put((b - a) / (b > a ? b : a));
                it1.advance();
            }
        }
        double penalty = 1.0;
        if (this.penalize && ignorednoise > 0) {
            penalty = (double)(rel.size() - ignorednoise) / (double)rel.size();
        }
        double meansil = penalty * msil.getMean();
        double stdsil = penalty * msil.getSampleStddev();
        if (LOG.isStatistics()) {
            LOG.statistics(new StringStatistic(this.key + ".silhouette.noise-handling", this.noiseOption.toString()));
            if (ignorednoise > 0) {
                LOG.statistics(new LongStatistic(this.key + ".silhouette.noise", ignorednoise));
            }
            LOG.statistics(new DoubleStatistic(this.key + ".silhouette.mean", meansil));
            LOG.statistics(new DoubleStatistic(this.key + ".silhouette.stddev", stdsil));
        }
        EvaluationResult ev = EvaluationResult.findOrCreate(db.getHierarchy(), c, "Internal Clustering Evaluation", "internal evaluation");
        EvaluationResult.MeasurementGroup g = ev.findOrCreateGroup("Distance-based Evaluation");
        g.addMeasure("Silhouette +-" + FormatUtil.NF2.format(stdsil), meansil, -1.0, 1.0, 0.0, false);
        db.getHierarchy().resultChanged(ev);
        return meansil;
    }

    @Override
    public void processNewResult(ResultHierarchy hier, Result result) {
        List<Clustering<Model>> crs = Clustering.getClusteringResults(result);
        if (crs.isEmpty()) {
            return;
        }
        Database db = ResultUtil.findDatabase(hier);
        Relation rel = db.getRelation(this.distance.getInputTypeRestriction(), new Object[0]);
        DistanceQuery<? super O> dq = db.getDistanceQuery(rel, this.distance, new Object[0]);
        for (Clustering<Model> c : crs) {
            this.evaluateClustering(db, rel, dq, c);
        }
    }

    public static class Parameterizer<O>
    extends AbstractParameterizer {
        public static final OptionID DISTANCE_ID = new OptionID("silhouette.distance", "Distance function to use for computing the silhouette.");
        public static final OptionID NOISE_ID = new OptionID("silhouette.noisehandling", "Control how noise should be treated.");
        public static final OptionID NO_PENALIZE_ID = new OptionID("silhouette.no-penalize-noise", "Do not penalize ignored noise.");
        private DistanceFunction<? super O> distance;
        private NoiseHandling noiseOption;
        private boolean penalize = true;

        @Override
        protected void makeOptions(Parameterization config) {
            Flag penalizeP;
            EnumParameter<NoiseHandling> noiseP;
            super.makeOptions(config);
            ObjectParameter distP = new ObjectParameter(DISTANCE_ID, (Class<?>)DistanceFunction.class, EuclideanDistanceFunction.class);
            if (config.grab(distP)) {
                this.distance = (DistanceFunction)distP.instantiateClass(config);
            }
            if (config.grab(noiseP = new EnumParameter<NoiseHandling>(NOISE_ID, NoiseHandling.class, NoiseHandling.TREAT_NOISE_AS_SINGLETONS))) {
                this.noiseOption = (NoiseHandling)((Object)noiseP.getValue());
            }
            if (this.noiseOption == NoiseHandling.IGNORE_NOISE && config.grab(penalizeP = new Flag(NO_PENALIZE_ID))) {
                this.penalize = penalizeP.isFalse();
            }
        }

        @Override
        protected EvaluateSilhouette<O> makeInstance() {
            return new EvaluateSilhouette<O>(this.distance, this.noiseOption, this.penalize);
        }
    }
}

