/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering.internal;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.model.ModelUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.evaluation.clustering.internal.EvaluateSilhouette;
import de.lmu.ifi.dbs.elki.evaluation.clustering.internal.NoiseHandling;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.StringStatistic;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.EvaluationResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;

public class EvaluateSimplifiedSilhouette
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(EvaluateSimplifiedSilhouette.class);
    private NoiseHandling noiseOption;
    private NumberVectorDistanceFunction<?> distance;
    private boolean penalize = true;
    private String key = EvaluateSimplifiedSilhouette.class.getName();

    public EvaluateSimplifiedSilhouette(NumberVectorDistanceFunction<?> distance, NoiseHandling noiseOpt, boolean penalize) {
        this.distance = distance;
        this.noiseOption = noiseOpt;
        this.penalize = penalize;
    }

    /*
     * Unable to fully structure code
     */
    public double evaluateClustering(Database db, Relation<? extends NumberVector> rel, Clustering<?> c) {
        clusters = c.getAllClusters();
        centroids = new NumberVector[clusters.size()];
        ignorednoise = EvaluateSimplifiedSilhouette.centroids(rel, clusters, centroids, this.noiseOption);
        mssil = new MeanVariance();
        ci = clusters.iterator();
        i = 0;
        while (ci.hasNext()) {
            block17: {
                block16: {
                    cluster = ci.next();
                    if (cluster.size() > 1) break block16;
                    mssil.put(0.0, cluster.size());
                    break block17;
                }
                if (!cluster.isNoise()) ** GOTO lbl-1000
                switch (1.$SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling[this.noiseOption.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        mssil.put(0.0, cluster.size());
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        center = centroids[i];
                        if (!EvaluateSimplifiedSilhouette.$assertionsDisabled && center == null) {
                            throw new AssertionError();
                        }
                        it = cluster.getIDs().iter();
                        while (it.valid()) {
                            obj = rel.get(it);
                            a = this.distance.distance(center, obj);
                            min = Infinity;
                            cj = clusters.iterator();
                            j = 0;
                            while (cj.hasNext()) {
                                ocluster = cj.next();
                                if (i == j) ** GOTO lbl50
                                other = centroids[j];
                                if (other != null) ** GOTO lbl-1000
                                switch (1.$SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling[this.noiseOption.ordinal()]) {
                                    case 1: {
                                        break;
                                    }
                                    case 2: {
                                        it2 = ocluster.getIDs().iter();
                                        while (it2.valid()) {
                                            dist = this.distance.distance(rel.get(it2), obj);
                                            min = dist < min ? dist : min;
                                            it2.advance();
                                        }
                                        break;
                                    }
                                    default: lbl-1000:
                                    // 2 sources

                                    {
                                        min = (dist = this.distance.distance(other, obj)) < min ? dist : min;
                                    }
                                }
lbl50:
                                // 4 sources

                                ++j;
                            }
                            min = min < Infinity ? min : a;
                            mssil.put((min - a) / (min > a ? min : a));
                            it.advance();
                        }
                        break block0;
                    }
                }
            }
            ++i;
        }
        penalty = 1.0;
        if (this.penalize && ignorednoise > 0) {
            penalty = (double)(rel.size() - ignorednoise) / (double)rel.size();
        }
        meanssil = penalty * mssil.getMean();
        stdssil = penalty * mssil.getSampleStddev();
        if (EvaluateSimplifiedSilhouette.LOG.isStatistics()) {
            EvaluateSimplifiedSilhouette.LOG.statistics(new StringStatistic(this.key + ".simplified-silhouette.noise-handling", this.noiseOption.toString()));
            if (ignorednoise > 0) {
                EvaluateSimplifiedSilhouette.LOG.statistics(new LongStatistic(this.key + ".simplified-silhouette.ignored", ignorednoise));
            }
            EvaluateSimplifiedSilhouette.LOG.statistics(new DoubleStatistic(this.key + ".simplified-silhouette.mean", meanssil));
            EvaluateSimplifiedSilhouette.LOG.statistics(new DoubleStatistic(this.key + ".simplified-silhouette.stddev", stdssil));
        }
        ev = EvaluationResult.findOrCreate(db.getHierarchy(), c, "Internal Clustering Evaluation", "internal evaluation");
        g = ev.findOrCreateGroup("Distance-based Evaluation");
        g.addMeasure("Simp. Silhouette +-" + FormatUtil.NF2.format(stdssil), meanssil, -1.0, 1.0, 0.0, false);
        db.getHierarchy().resultChanged(ev);
        return meanssil;
    }

    /*
     * Unable to fully structure code
     */
    public static int centroids(Relation<? extends NumberVector> rel, List<? extends Cluster<?>> clusters, NumberVector[] centroids, NoiseHandling noiseOption) {
        if (!EvaluateSimplifiedSilhouette.$assertionsDisabled && centroids.length != clusters.size()) {
            throw new AssertionError();
        }
        ignorednoise = 0;
        ci = clusters.iterator();
        i = 0;
        while (ci.hasNext()) {
            cluster = ci.next();
            if (cluster.size() > 1 && !cluster.isNoise()) ** GOTO lbl-1000
            switch (1.$SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling[noiseOption.ordinal()]) {
                case 1: {
                    ignorednoise += cluster.size();
                }
                case 2: {
                    centroids[i] = null;
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    centroids[i] = ModelUtil.getPrototypeOrCentroid(cluster.getModel(), rel, cluster.getIDs());
                }
            }
            ++i;
        }
        return ignorednoise;
    }

    @Override
    public void processNewResult(ResultHierarchy hier, Result result) {
        List<Clustering<Model>> crs = Clustering.getClusteringResults(result);
        if (crs.isEmpty()) {
            return;
        }
        Database db = ResultUtil.findDatabase(hier);
        Relation rel = db.getRelation(this.distance.getInputTypeRestriction(), new Object[0]);
        for (Clustering<Model> c : crs) {
            this.evaluateClustering(db, rel, c);
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        private NumberVectorDistanceFunction<?> distance;
        private NoiseHandling noiseOption;
        private boolean penalize = true;

        @Override
        protected void makeOptions(Parameterization config) {
            Flag penalizeP;
            EnumParameter<NoiseHandling> noiseP;
            super.makeOptions(config);
            ObjectParameter distanceFunctionP = new ObjectParameter(EvaluateSilhouette.Parameterizer.DISTANCE_ID, (Class<?>)NumberVectorDistanceFunction.class, EuclideanDistanceFunction.class);
            if (config.grab(distanceFunctionP)) {
                this.distance = (NumberVectorDistanceFunction)distanceFunctionP.instantiateClass(config);
            }
            if (config.grab(noiseP = new EnumParameter<NoiseHandling>(EvaluateSilhouette.Parameterizer.NOISE_ID, NoiseHandling.class, NoiseHandling.TREAT_NOISE_AS_SINGLETONS))) {
                this.noiseOption = (NoiseHandling)((Object)noiseP.getValue());
            }
            if (this.noiseOption == NoiseHandling.IGNORE_NOISE && config.grab(penalizeP = new Flag(EvaluateSilhouette.Parameterizer.NO_PENALIZE_ID))) {
                this.penalize = penalizeP.isFalse();
            }
        }

        @Override
        protected EvaluateSimplifiedSilhouette makeInstance() {
            return new EvaluateSimplifiedSilhouette(this.distance, this.noiseOption, this.penalize);
        }
    }
}

