/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering.internal;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.model.ModelUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.evaluation.clustering.internal.NoiseHandling;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.result.EvaluationResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;
import net.jafama.FastMath;

public class EvaluateSquaredErrors
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(EvaluateSquaredErrors.class);
    private NoiseHandling noiseOption;
    private NumberVectorDistanceFunction<?> distance;
    private String key = EvaluateSquaredErrors.class.getName();

    public EvaluateSquaredErrors(NumberVectorDistanceFunction<?> distance, NoiseHandling noiseOption) {
        this.distance = distance;
        this.noiseOption = noiseOption;
    }

    public double evaluateClustering(Database db, Relation<? extends NumberVector> rel, Clustering<?> c) {
        boolean square = !this.distance.isSquared();
        int ignorednoise = 0;
        List<Cluster<?>> clusters = c.getAllClusters();
        double ssq = 0.0;
        double sum = 0.0;
        block4: for (Cluster<?> cluster : clusters) {
            if (cluster.size() <= 1 || cluster.isNoise()) {
                switch (this.noiseOption) {
                    case IGNORE_NOISE: {
                        ignorednoise += cluster.size();
                        continue block4;
                    }
                    case TREAT_NOISE_AS_SINGLETONS: {
                        continue block4;
                    }
                }
            }
            NumberVector center = ModelUtil.getPrototypeOrCentroid(cluster.getModel(), rel, cluster.getIDs());
            DBIDIter it1 = cluster.getIDs().iter();
            while (it1.valid()) {
                double d = this.distance.distance(center, rel.get(it1));
                sum += d;
                ssq += square ? d * d : d;
                it1.advance();
            }
        }
        int div = Math.max(1, rel.size() - ignorednoise);
        if (LOG.isStatistics()) {
            LOG.statistics(new DoubleStatistic(this.key + ".mean", sum / (double)div));
            LOG.statistics(new DoubleStatistic(this.key + ".ssq", ssq));
            LOG.statistics(new DoubleStatistic(this.key + ".rmsd", FastMath.sqrt(ssq / (double)div)));
        }
        EvaluationResult ev = EvaluationResult.findOrCreate(db.getHierarchy(), c, "Internal Clustering Evaluation", "internal evaluation");
        EvaluationResult.MeasurementGroup g = ev.findOrCreateGroup("Distance-based Evaluation");
        g.addMeasure("Mean distance", sum / (double)div, 0.0, Double.POSITIVE_INFINITY, true);
        g.addMeasure("Sum of Squares", ssq, 0.0, Double.POSITIVE_INFINITY, true);
        g.addMeasure("RMSD", FastMath.sqrt(ssq / (double)div), 0.0, Double.POSITIVE_INFINITY, true);
        db.getHierarchy().add(c, ev);
        return ssq;
    }

    @Override
    public void processNewResult(ResultHierarchy hier, Result result) {
        List<Clustering<Model>> crs = Clustering.getClusteringResults(result);
        if (crs.isEmpty()) {
            return;
        }
        Database db = ResultUtil.findDatabase(hier);
        Relation rel = db.getRelation(this.distance.getInputTypeRestriction(), new Object[0]);
        for (Clustering<Model> c : crs) {
            this.evaluateClustering(db, rel, c);
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID DISTANCE_ID = new OptionID("ssq.distance", "Distance function to use for computing the SSQ.");
        public static final OptionID NOISE_ID = new OptionID("ssq.noisehandling", "Control how noise should be treated.");
        private NumberVectorDistanceFunction<?> distance;
        private NoiseHandling noiseOption;

        @Override
        protected void makeOptions(Parameterization config) {
            EnumParameter<NoiseHandling> noiseP;
            super.makeOptions(config);
            ObjectParameter distP = new ObjectParameter(DISTANCE_ID, (Class<?>)NumberVectorDistanceFunction.class, SquaredEuclideanDistanceFunction.class);
            if (config.grab(distP)) {
                this.distance = (NumberVectorDistanceFunction)distP.instantiateClass(config);
            }
            if (config.grab(noiseP = new EnumParameter<NoiseHandling>(NOISE_ID, NoiseHandling.class, NoiseHandling.TREAT_NOISE_AS_SINGLETONS))) {
                this.noiseOption = (NoiseHandling)((Object)noiseP.getValue());
            }
        }

        @Override
        protected EvaluateSquaredErrors makeInstance() {
            return new EvaluateSquaredErrors(this.distance, this.noiseOption);
        }
    }
}

