/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering.internal;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.evaluation.clustering.internal.EvaluateSimplifiedSilhouette;
import de.lmu.ifi.dbs.elki.evaluation.clustering.internal.NoiseHandling;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.StringStatistic;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Centroid;
import de.lmu.ifi.dbs.elki.result.EvaluationResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import java.util.List;

@Reference(authors="R. B. Calinski, J. Harabasz", title="A dendrite method for cluster analysis", booktitle="Communications in Statistics - Theory and Methods 3(1)", url="https://doi.org/10.1080/03610927408827101", bibkey="doi:10.1080/03610927408827101")
@Alias(value={"calinski-harabasz"})
public class EvaluateVarianceRatioCriteria<O>
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(EvaluateVarianceRatioCriteria.class);
    private NoiseHandling noiseOption;
    private boolean penalize = true;
    private String key = EvaluateVarianceRatioCriteria.class.getName();

    public EvaluateVarianceRatioCriteria(NoiseHandling noiseOption, boolean penalize) {
        this.noiseOption = noiseOption;
        this.penalize = penalize;
    }

    /*
     * Unable to fully structure code
     */
    public double evaluateClustering(Database db, Relation<? extends NumberVector> rel, Clustering<?> c) {
        block10: {
            df = SquaredEuclideanDistanceFunction.STATIC;
            clusters = c.getAllClusters();
            vrc = 0.0;
            ignorednoise = 0;
            if (clusters.size() <= 1) break block10;
            centroids = new NumberVector[clusters.size()];
            ignorednoise = EvaluateSimplifiedSilhouette.centroids(rel, clusters, centroids, this.noiseOption);
            dim = RelationUtil.dimensionality(rel);
            overallCentroid = new Centroid(dim);
            clustercount = EvaluateVarianceRatioCriteria.globalCentroid(overallCentroid, rel, clusters, centroids, this.noiseOption);
            a = 0.0;
            b = 0.0;
            ci = clusters.iterator();
            i = 0;
            while (ci.hasNext()) {
                cluster = ci.next();
                if (cluster.size() > 1 && !cluster.isNoise()) ** GOTO lbl-1000
                switch (1.$SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling[this.noiseOption.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        it = cluster.getIDs().iter();
                        while (it.valid()) {
                            b += df.distance(overallCentroid, rel.get(it));
                            it.advance();
                        }
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        it = cluster.getIDs().iter();
                        while (it.valid()) {
                            vec = rel.get(it);
                            a += df.distance(centroids[i], vec);
                            b += df.distance(overallCentroid, vec);
                            it.advance();
                        }
                        break block0;
                    }
                }
                ++i;
            }
            vrc = (b - a) / a * ((double)(rel.size() - clustercount) / ((double)clustercount - 1.0));
            if (this.penalize && ignorednoise > 0) {
                vrc *= (double)(rel.size() - ignorednoise) / (double)rel.size();
            }
        }
        if (EvaluateVarianceRatioCriteria.LOG.isStatistics()) {
            EvaluateVarianceRatioCriteria.LOG.statistics(new StringStatistic(this.key + ".vrc.noise-handling", this.noiseOption.toString()));
            if (ignorednoise > 0) {
                EvaluateVarianceRatioCriteria.LOG.statistics(new LongStatistic(this.key + ".vrc.ignored", ignorednoise));
            }
            EvaluateVarianceRatioCriteria.LOG.statistics(new DoubleStatistic(this.key + ".vrc", vrc));
        }
        ev = EvaluationResult.findOrCreate(db.getHierarchy(), c, "Internal Clustering Evaluation", "internal evaluation");
        g = ev.findOrCreateGroup("Distance-based Evaluation");
        g.addMeasure("Variance Ratio Criteria", vrc, 0.0, 1.0, 0.0, false);
        return vrc;
    }

    /*
     * Unable to fully structure code
     */
    public static int globalCentroid(Centroid overallCentroid, Relation<? extends NumberVector> rel, List<? extends Cluster<?>> clusters, NumberVector[] centroids, NoiseHandling noiseOption) {
        clustercount = 0;
        ci = clusters.iterator();
        i = 0;
        while (ci.hasNext()) {
            cluster = ci.next();
            if (cluster.size() > 1 && !cluster.isNoise()) ** GOTO lbl-1000
            switch (1.$SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling[noiseOption.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    clustercount += cluster.size();
                    it = cluster.getIDs().iter();
                    while (it.valid()) {
                        overallCentroid.put(rel.get(it));
                        it.advance();
                    }
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    if (!EvaluateVarianceRatioCriteria.$assertionsDisabled && centroids[i] == null) {
                        throw new AssertionError();
                    }
                    overallCentroid.put(centroids[i], (double)cluster.size());
                    ++clustercount;
                }
            }
            ++i;
        }
        return clustercount;
    }

    @Override
    public void processNewResult(ResultHierarchy hier, Result result) {
        List<Clustering<Model>> crs = Clustering.getClusteringResults(result);
        if (crs.isEmpty()) {
            return;
        }
        Database db = ResultUtil.findDatabase(hier);
        Relation rel = db.getRelation(EuclideanDistanceFunction.STATIC.getInputTypeRestriction(), new Object[0]);
        for (Clustering<Model> c : crs) {
            this.evaluateClustering(db, rel, c);
        }
    }

    public static class Parameterizer<O>
    extends AbstractParameterizer {
        public static final OptionID NOISE_ID = new OptionID("vrc.noisehandling", "Control how noise should be treated.");
        public static final OptionID NO_PENALIZE_ID = new OptionID("silhouette.no-penalize-noise", "Do not penalize ignored noise.");
        private NoiseHandling noiseOption;
        private boolean penalize = true;

        @Override
        protected void makeOptions(Parameterization config) {
            Flag penalizeP;
            super.makeOptions(config);
            EnumParameter<NoiseHandling> noiseP = new EnumParameter<NoiseHandling>(NOISE_ID, NoiseHandling.class, NoiseHandling.TREAT_NOISE_AS_SINGLETONS);
            if (config.grab(noiseP)) {
                this.noiseOption = (NoiseHandling)((Object)noiseP.getValue());
            }
            if (this.noiseOption == NoiseHandling.IGNORE_NOISE && config.grab(penalizeP = new Flag(NO_PENALIZE_ID))) {
                this.penalize = penalizeP.isFalse();
            }
        }

        @Override
        protected EvaluateVarianceRatioCriteria<? extends NumberVector> makeInstance() {
            return new EvaluateVarianceRatioCriteria(this.noiseOption, this.penalize);
        }
    }
}

