/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering.pairsegments;

import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import java.util.Arrays;

public class Segment
implements Comparable<Segment> {
    public static final int UNCLUSTERED = -1;
    protected DBIDs objIDs = null;
    protected long pairsize = 0L;
    protected int[] clusterIds;

    public Segment(int clusterings) {
        this.clusterIds = new int[clusterings];
    }

    public long getPairCount() {
        return this.pairsize;
    }

    public Segment(int[] clone) {
        this.clusterIds = clone;
    }

    public int get(int idx) {
        return this.clusterIds[idx];
    }

    public boolean isUnpaired() {
        for (int id : this.clusterIds) {
            if (id != -1) continue;
            return true;
        }
        return false;
    }

    public boolean isNone() {
        for (int id : this.clusterIds) {
            if (id == -1) continue;
            return false;
        }
        return true;
    }

    public int getUnpairedClusteringIndex() {
        for (int index = 0; index < this.clusterIds.length; ++index) {
            if (this.clusterIds[index] != -1) continue;
            return index;
        }
        return -1;
    }

    public DBIDs getDBIDs() {
        return this.objIDs;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!Segment.class.isInstance(obj)) {
            return false;
        }
        Segment other = (Segment)obj;
        return Arrays.equals(this.clusterIds, other.clusterIds);
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public int compareTo(Segment sid) {
        for (int i = 0; i < this.clusterIds.length; ++i) {
            int a = this.clusterIds[i];
            int b = sid.clusterIds[i];
            if (a == b) continue;
            if (a * b > 0) {
                return a < b ? -1 : 1;
            }
            return a < b ? 1 : -1;
        }
        return 0;
    }
}

