/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering.pairsegments;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.evaluation.clustering.pairsegments.Segment;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.BasicResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

@Reference(authors="Elke Achtert, Sascha Goldhofer, Hans-Peter Kriegel, Erich Schubert, Arthur Zimek", title="Evaluation of Clusterings - Metrics and Visual Support", booktitle="Proc. 28th International Conference on Data Engineering (ICDE 2012)", url="https://doi.org/10.1109/ICDE.2012.128", bibkey="DBLP:conf/icde/AchtertGKSZ12")
public class Segments
extends BasicResult
implements Iterable<Segment> {
    private static final Logging LOG = Logging.getLogger(Segments.class);
    private List<Clustering<?>> clusterings;
    private List<List<? extends Cluster<?>>> clusters;
    private int clusteringsCount;
    private int[] numclusters;
    private int totalObjects;
    private long actualPairs;
    private TreeMap<Segment, Segment> segments;

    public Segments(List<Clustering<?>> clusterings) {
        super("cluster pair segments", "pair-segments");
        this.clusterings = clusterings;
        this.clusteringsCount = clusterings.size();
        this.segments = new TreeMap();
        this.numclusters = new int[this.clusteringsCount];
        this.clusters = new ArrayList(this.clusteringsCount);
        int clusteringIndex = 0;
        for (Clustering<?> clr : clusterings) {
            List<Cluster<?>> curClusters = clr.getAllClusters();
            this.clusters.add(curClusters);
            this.numclusters[clusteringIndex] = curClusters.size();
            ++clusteringIndex;
        }
        this.recursivelyFill(this.clusters);
        for (Segment seg : this.segments.keySet()) {
            this.actualPairs += seg.pairsize;
        }
    }

    private void recursivelyFill(List<List<? extends Cluster<?>>> cs) {
        int numclusterings = cs.size();
        Iterator<Cluster<?>> iter = cs.get(0).iterator();
        int[] path = new int[numclusterings];
        int cnum = 0;
        while (iter.hasNext()) {
            Cluster<?> clust = iter.next();
            path[0] = cnum;
            if (numclusterings > 1) {
                SetDBIDs idset = DBIDUtil.ensureSet(clust.getIDs());
                this.recursivelyFill(cs, 1, idset, idset, path, true);
            } else {
                this.makeOrUpdateSegment(path, clust.getIDs(), clust.size() * (clust.size() - 1) >>> 1);
            }
            this.totalObjects += clust.size();
            ++cnum;
        }
    }

    private void recursivelyFill(List<List<? extends Cluster<?>>> cs, int depth, SetDBIDs first, SetDBIDs second, int[] path, boolean objectsegment) {
        int numclusterings = cs.size();
        Iterator<Cluster<?>> iter = cs.get(depth).iterator();
        int cnum = 0;
        while (iter.hasNext()) {
            Cluster<?> clust = iter.next();
            HashSetModifiableDBIDs nfirstp = DBIDUtil.newHashSet(first.size());
            HashSetModifiableDBIDs ndelta1 = DBIDUtil.newHashSet(first);
            HashSetModifiableDBIDs ndelta2 = DBIDUtil.newHashSet();
            HashSetModifiableDBIDs nsecond = DBIDUtil.newHashSet(second.size());
            DBIDIter iter2 = clust.getIDs().iter();
            while (iter2.valid()) {
                if (ndelta1.remove(iter2)) {
                    nfirstp.add(iter2);
                } else {
                    ndelta2.add(iter2);
                }
                if (second.contains(iter2)) {
                    nsecond.add(iter2);
                }
                iter2.advance();
            }
            if (nsecond.size() > 0) {
                if (nfirstp.size() > 0) {
                    path[depth] = cnum;
                    if (depth < numclusterings - 1) {
                        this.recursivelyFill(cs, depth + 1, nfirstp, nsecond, path, objectsegment);
                    } else {
                        int selfpairs = DBIDUtil.intersectionSize(nfirstp, nsecond);
                        if (objectsegment) {
                            this.makeOrUpdateSegment(path, nfirstp, nfirstp.size() * nsecond.size() - selfpairs);
                        } else {
                            this.makeOrUpdateSegment(path, null, nfirstp.size() * nsecond.size() - selfpairs);
                        }
                    }
                }
                if (ndelta1.size() > 0) {
                    path[depth] = -1;
                    if (depth < numclusterings - 1) {
                        this.recursivelyFill(cs, depth + 1, ndelta1, nsecond, path, false);
                    } else {
                        int selfpairs = DBIDUtil.intersection(ndelta1, nsecond).size();
                        this.makeOrUpdateSegment(path, null, ndelta1.size() * nsecond.size() - selfpairs);
                    }
                }
                if (ndelta2.size() > 0 && objectsegment) {
                    int[] npath = new int[path.length];
                    Arrays.fill(npath, -1);
                    npath[depth] = cnum;
                    if (depth < numclusterings - 1) {
                        this.recursivelyFill(cs, depth + 1, ndelta2, nsecond, npath, false);
                    } else {
                        int selfpairs = DBIDUtil.intersection(ndelta2, nsecond).size();
                        this.makeOrUpdateSegment(npath, null, ndelta2.size() * nsecond.size() - selfpairs);
                    }
                }
            }
            ++cnum;
        }
    }

    private void makeOrUpdateSegment(int[] path, DBIDs ids, int pairsize) {
        Segment seg = this.segments.get(new Segment(path));
        if (seg == null) {
            seg = new Segment((int[])path.clone());
            this.segments.put(seg, seg);
        }
        if (ids != null) {
            if (seg.getDBIDs() != null) {
                LOG.warning("Expected segment to not have IDs.");
            }
            seg.objIDs = ids;
        }
        seg.pairsize += (long)pairsize;
    }

    public String getClusteringDescription(int clusteringID) {
        return this.clusterings.get(clusteringID).getLongName();
    }

    public List<Segment> getPairedSegments(Segment unpairedSegment) {
        ArrayList<Segment> pairedSegments = new ArrayList<Segment>();
        block0: for (Segment segment : this) {
            for (int i = 0; i < this.clusteringsCount; ++i) {
                if (unpairedSegment.get(i) != -1 && segment.get(i) != unpairedSegment.get(i) || segment.get(i) == -1) continue block0;
            }
            pairedSegments.add(segment);
        }
        return pairedSegments;
    }

    public Segment unifySegment(Segment temp) {
        Segment found = this.segments.get(temp);
        return found != null ? found : temp;
    }

    public int size() {
        return this.segments.size();
    }

    public long getPairCount(boolean withUnclusteredPairs) {
        return withUnclusteredPairs ? (long)this.totalObjects * ((long)this.totalObjects - 1L) >> 1 : this.actualPairs;
    }

    public int getClusterings() {
        return this.clusteringsCount;
    }

    public int getTotalClusterCount() {
        int clusterCount = 0;
        for (int i = 0; i < this.numclusters.length; ++i) {
            clusterCount += this.numclusters[i];
        }
        return clusterCount;
    }

    public int getHighestClusterCount() {
        int maxClusters = 0;
        for (int i = 0; i < this.numclusters.length; ++i) {
            maxClusters = Math.max(maxClusters, this.numclusters[i]);
        }
        return maxClusters;
    }

    @Override
    public Iterator<Segment> iterator() {
        return this.segments.keySet().iterator();
    }
}

