/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.index;

import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.DatabaseUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialDirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialIndexTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialPointLeafEntry;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.CollectionResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IndexPurity
implements Evaluator {
    @Override
    public void processNewResult(ResultHierarchy hier, Result newResult) {
        Database database = ResultUtil.findDatabase(hier);
        ArrayList<SpatialIndexTree> indexes = ResultUtil.filterResults(hier, newResult, SpatialIndexTree.class);
        if (indexes == null || indexes.isEmpty()) {
            return;
        }
        Relation<String> lblrel = DatabaseUtil.guessLabelRepresentation(database);
        for (SpatialIndexTree index : indexes) {
            List leaves = index.getLeaves();
            MeanVariance mv = new MeanVariance();
            for (SpatialEntry e : leaves) {
                SpatialDirectoryEntry leaf = (SpatialDirectoryEntry)e;
                Object n = index.getNode(leaf.getPageID());
                int total = n.getNumEntries();
                HashMap<String, Integer> map = new HashMap<String, Integer>(total);
                for (int i = 0; i < total; ++i) {
                    DBID id = ((SpatialPointLeafEntry)n.getEntry(i)).getDBID();
                    String label = lblrel.get(id);
                    Integer val = (Integer)map.get(label);
                    val = val == null ? Integer.valueOf(1) : Integer.valueOf(val + 1);
                    map.put(label, val);
                }
                double gini = 0.0;
                for (Map.Entry ent : map.entrySet()) {
                    double rel = (double)((Integer)ent.getValue()).intValue() / (double)total;
                    gini += rel * rel;
                }
                mv.put(gini);
            }
            ArrayList<double[]> col = new ArrayList<double[]>();
            col.add(new double[]{mv.getMean(), mv.getSampleStddev()});
            database.getHierarchy().add(index, new CollectionResult("Gini coefficient of index", "index-gini", col));
        }
    }
}

