/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.outlier;

import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.DatabaseUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.result.HistogramResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.AbstractObjDynamicHistogram;
import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.ObjHistogram;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.IdentityScaling;
import de.lmu.ifi.dbs.elki.utilities.scaling.ScalingFunction;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScaling;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;

@Alias(value={"de.lmu.ifi.dbs.elki.evaluation.histogram.ComputeOutlierHistogram"})
public class ComputeOutlierHistogram
implements Evaluator {
    private Pattern positiveClassName = null;
    private int bins;
    private ScalingFunction scaling;
    private boolean splitfreq = false;

    public ComputeOutlierHistogram(Pattern positive_class_name, int bins, ScalingFunction scaling, boolean splitfreq) {
        this.positiveClassName = positive_class_name;
        this.bins = bins;
        this.scaling = scaling;
        this.splitfreq = splitfreq;
    }

    public HistogramResult evaluateOutlierResult(Database database, OutlierResult or) {
        double result;
        double negative;
        if (this.scaling instanceof OutlierScaling) {
            ((OutlierScaling)this.scaling).prepare(or);
        }
        HashSetModifiableDBIDs ids = DBIDUtil.newHashSet(or.getScores().getDBIDs());
        ArrayModifiableDBIDs outlierIds = DatabaseUtil.getObjectsByLabelMatch(database, this.positiveClassName);
        double min = this.scaling.getMin();
        double max = this.scaling.getMax();
        ObjHistogram hist = Double.isInfinite(min) || Double.isNaN(min) || Double.isInfinite(max) || Double.isNaN(max) ? new AbstractObjDynamicHistogram<double[]>(this.bins){

            @Override
            public double[] aggregate(double[] first, double[] second) {
                return VMath.plusEquals(first, second);
            }

            @Override
            protected double[] makeObject() {
                return new double[2];
            }

            @Override
            protected double[] cloneForCache(double[] data) {
                return (double[])data.clone();
            }

            @Override
            protected double[] downsample(Object[] data, int start, int end, int size) {
                double[] sum = new double[2];
                for (int i = start; i < end; ++i) {
                    Object p = data[i];
                    if (p == null) continue;
                    VMath.plusEquals(sum, (double[])p);
                }
                return sum;
            }
        } : new ObjHistogram<double[]>(this.bins, min, max, () -> new double[2]);
        double positive = negative = 1.0 / (double)ids.size();
        if (this.splitfreq) {
            negative = 1.0 / (double)(ids.size() - outlierIds.size());
            positive = 1.0 / (double)outlierIds.size();
        }
        ids.removeDBIDs(outlierIds);
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            result = or.getScores().doubleValue(iter);
            if ((result = this.scaling.getScaled(result)) > Double.NEGATIVE_INFINITY && result < Double.POSITIVE_INFINITY) {
                double[] dArray = (double[])hist.get(result);
                dArray[0] = dArray[0] + negative;
            }
            iter.advance();
        }
        iter = outlierIds.iter();
        while (iter.valid()) {
            result = or.getScores().doubleValue(iter);
            if ((result = this.scaling.getScaled(result)) > Double.NEGATIVE_INFINITY && result < Double.POSITIVE_INFINITY) {
                double[] dArray = (double[])hist.get(result);
                dArray[1] = dArray[1] + positive;
            }
            iter.advance();
        }
        ArrayList<double[]> collHist = new ArrayList<double[]>(hist.getNumBins());
        ObjHistogram.Iter iter2 = hist.iter();
        while (iter2.valid()) {
            double[] data = (double[])iter2.getValue();
            collHist.add(new double[]{iter2.getCenter(), data[0], data[1]});
            iter2.advance();
        }
        return new HistogramResult("Outlier Score Histogram", "outlier-histogram", (Collection<double[]>)collHist);
    }

    @Override
    public void processNewResult(ResultHierarchy hier, Result newResult) {
        Database db = ResultUtil.findDatabase(hier);
        ArrayList<OutlierResult> ors = ResultUtil.filterResults(hier, newResult, OutlierResult.class);
        if (ors == null || ors.isEmpty()) {
            return;
        }
        for (OutlierResult or : ors) {
            db.getHierarchy().add(or, this.evaluateOutlierResult(db, or));
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID POSITIVE_CLASS_NAME_ID = new OptionID("comphist.positive", "Class label for the 'positive' class.");
        public static final OptionID BINS_ID = new OptionID("comphist.bins", "number of bins");
        public static final OptionID SCALING_ID = new OptionID("comphist.scaling", "Class to use as scaling function.");
        public static final OptionID SPLITFREQ_ID = new OptionID("histogram.splitfreq", "Use separate frequencies for outliers and non-outliers.");
        protected Pattern positiveClassName = null;
        protected int bins;
        protected ScalingFunction scaling;
        protected boolean splitfreq = false;

        @Override
        protected void makeOptions(Parameterization config) {
            Flag splitfreqF;
            ObjectParameter scalingP;
            IntParameter binsP;
            super.makeOptions(config);
            PatternParameter positiveClassNameP = (PatternParameter)new PatternParameter(POSITIVE_CLASS_NAME_ID).setOptional(true);
            if (config.grab(positiveClassNameP)) {
                this.positiveClassName = (Pattern)positiveClassNameP.getValue();
            }
            if (config.grab(binsP = (IntParameter)new IntParameter(BINS_ID, 50).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT))) {
                this.bins = (Integer)binsP.getValue();
            }
            if (config.grab(scalingP = new ObjectParameter(SCALING_ID, (Class<?>)ScalingFunction.class, IdentityScaling.class))) {
                this.scaling = (ScalingFunction)scalingP.instantiateClass(config);
            }
            if (config.grab(splitfreqF = new Flag(SPLITFREQ_ID))) {
                this.splitfreq = (Boolean)splitfreqF.getValue();
            }
        }

        @Override
        protected ComputeOutlierHistogram makeInstance() {
            return new ComputeOutlierHistogram(this.positiveClassName, this.bins, this.scaling, this.splitfreq);
        }
    }
}

