/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.outlier;

import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.DatabaseUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.CollectionResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.IdentityScaling;
import de.lmu.ifi.dbs.elki.utilities.scaling.LinearScaling;
import de.lmu.ifi.dbs.elki.utilities.scaling.ScalingFunction;
import de.lmu.ifi.dbs.elki.utilities.scaling.StaticScalingFunction;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScaling;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;

public class JudgeOutlierScores
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(JudgeOutlierScores.class);
    private Pattern positiveClassName;
    private ScalingFunction scaling;

    public JudgeOutlierScores(Pattern positive_class_name, ScalingFunction scaling) {
        this.positiveClassName = positive_class_name;
        this.scaling = scaling;
    }

    protected ScoreResult computeScore(DBIDs ids, DBIDs outlierIds, OutlierResult or) throws IllegalStateException {
        double result;
        StaticScalingFunction innerScaling;
        if (this.scaling instanceof OutlierScaling) {
            OutlierScaling oscaling = (OutlierScaling)this.scaling;
            oscaling.prepare(or);
        }
        double min = this.scaling.getMin();
        double max = this.scaling.getMax();
        if (Double.isInfinite(min) || Double.isNaN(min) || Double.isInfinite(max) || Double.isNaN(max)) {
            innerScaling = new IdentityScaling();
            LOG.warning("JudgeOutlierScores expects values between 0.0 and 1.0, but we don't have such a guarantee by the scaling function: min:" + min + " max:" + max);
        } else {
            innerScaling = min == 0.0 && max == 1.0 ? new IdentityScaling() : new LinearScaling(1.0 / (max - min), -min);
        }
        double posscore = 0.0;
        double negscore = 0.0;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            result = or.getScores().doubleValue(iter);
            result = innerScaling.getScaled(this.scaling.getScaled(result));
            posscore += 1.0 - result;
            iter.advance();
        }
        iter = outlierIds.iter();
        while (iter.valid()) {
            result = or.getScores().doubleValue(iter);
            result = innerScaling.getScaled(this.scaling.getScaled(result));
            negscore += result;
            iter.advance();
        }
        LOG.verbose("Scores: " + (posscore /= (double)ids.size()) + " " + (negscore /= (double)outlierIds.size()));
        ArrayList<double[]> s = new ArrayList<double[]>(1);
        s.add(new double[]{(posscore + negscore) * 0.5, posscore, negscore});
        return new ScoreResult(s);
    }

    @Override
    public void processNewResult(ResultHierarchy hier, Result result) {
        Database db = ResultUtil.findDatabase(hier);
        ArrayList<OutlierResult> ors = ResultUtil.filterResults(hier, OutlierResult.class);
        if (ors == null || ors.isEmpty()) {
            return;
        }
        HashSetModifiableDBIDs ids = DBIDUtil.newHashSet(((OutlierResult)ors.iterator().next()).getScores().getDBIDs());
        ArrayModifiableDBIDs outlierIds = DatabaseUtil.getObjectsByLabelMatch(db, this.positiveClassName);
        ids.removeDBIDs(outlierIds);
        for (OutlierResult or : ors) {
            db.getHierarchy().add(or, this.computeScore(ids, outlierIds, or));
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID POSITIVE_CLASS_NAME_ID = new OptionID("comphist.positive", "Class label for the 'positive' class.");
        public static final OptionID SCALING_ID = new OptionID("comphist.scaling", "Class to use as scaling function.");
        private Pattern positiveClassName;
        private ScalingFunction scaling;

        @Override
        protected void makeOptions(Parameterization config) {
            ObjectParameter scalingP;
            super.makeOptions(config);
            PatternParameter positiveClassNameP = new PatternParameter(POSITIVE_CLASS_NAME_ID);
            if (config.grab(positiveClassNameP)) {
                this.positiveClassName = (Pattern)positiveClassNameP.getValue();
            }
            if (config.grab(scalingP = new ObjectParameter(SCALING_ID, (Class<?>)ScalingFunction.class, IdentityScaling.class))) {
                this.scaling = (ScalingFunction)scalingP.instantiateClass(config);
            }
        }

        @Override
        protected JudgeOutlierScores makeInstance() {
            return new JudgeOutlierScores(this.positiveClassName, this.scaling);
        }
    }

    public class ScoreResult
    extends CollectionResult<double[]> {
        public ScoreResult(Collection<double[]> col) {
            super("Outlier Score", "outlier-score", col);
        }
    }
}

