/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.outlier;

import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.DatabaseUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.geometry.XYCurve;
import de.lmu.ifi.dbs.elki.result.OrderingResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import java.util.List;
import java.util.regex.Pattern;

public class OutlierPrecisionAtKCurve
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(OutlierPrecisionAtKCurve.class);
    private Pattern positiveClassName;
    private int maxk = Integer.MAX_VALUE;

    public OutlierPrecisionAtKCurve(Pattern positiveClassName, int maxk) {
        this.positiveClassName = positiveClassName;
        this.maxk = maxk;
    }

    @Override
    public void processNewResult(ResultHierarchy hier, Result result) {
        ArrayModifiableDBIDs sorted;
        Database db = ResultUtil.findDatabase(hier);
        SetDBIDs positiveids = DBIDUtil.ensureSet(DatabaseUtil.getObjectsByLabelMatch(db, this.positiveClassName));
        if (positiveids.size() == 0) {
            LOG.warning("Computing a ROC curve failed - no objects matched.");
            return;
        }
        List<OutlierResult> oresults = OutlierResult.getOutlierResults(result);
        List<OrderingResult> orderings = ResultUtil.getOrderingResults(result);
        for (OutlierResult o : oresults) {
            sorted = o.getOrdering().order(o.getOrdering().getDBIDs());
            db.getHierarchy().add(o, this.computePrecisionResult(o.getScores().size(), positiveids, sorted));
            orderings.remove(o.getOrdering());
        }
        for (OrderingResult or : orderings) {
            sorted = or.order(or.getDBIDs());
            db.getHierarchy().add(or, this.computePrecisionResult(or.getDBIDs().size(), positiveids, sorted));
        }
    }

    private XYCurve computePrecisionResult(int size, SetDBIDs positiveids, DBIDs order) {
        if (order.size() != size) {
            throw new IllegalStateException("Iterable result doesn't match database size - incomplete ordering?");
        }
        int lastk = Math.min(size, this.maxk);
        PrecisionAtKCurve curve = new PrecisionAtKCurve(lastk);
        int pos = 0;
        DBIDIter i = order.iter();
        for (int k = 1; k <= lastk; ++k) {
            if (positiveids.contains(i)) {
                ++pos;
            }
            curve.addAndSimplify(k, (double)pos / (double)k);
            i.advance();
        }
        return curve;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID POSITIVE_CLASS_NAME_ID = new OptionID("precision.positive", "Class label for the 'positive' class.");
        public static final OptionID MAX_K_ID = new OptionID("precision.maxk", "Maximum value of 'k' to compute the curve up to.");
        private Pattern positiveClassName;
        private int maxk = Integer.MAX_VALUE;

        @Override
        protected void makeOptions(Parameterization config) {
            IntParameter maxkP;
            super.makeOptions(config);
            PatternParameter positiveClassNameP = new PatternParameter(POSITIVE_CLASS_NAME_ID);
            if (config.grab(positiveClassNameP)) {
                this.positiveClassName = (Pattern)positiveClassNameP.getValue();
            }
            if (config.grab(maxkP = (IntParameter)new IntParameter(MAX_K_ID).setOptional(true))) {
                this.maxk = (Integer)maxkP.getValue();
            }
        }

        @Override
        protected OutlierPrecisionAtKCurve makeInstance() {
            return new OutlierPrecisionAtKCurve(this.positiveClassName, this.maxk);
        }
    }

    public static class PrecisionAtKCurve
    extends XYCurve {
        public PrecisionAtKCurve(int size) {
            super("k", "Precision", size);
        }

        @Override
        public String getLongName() {
            return "Precision @ k Curve";
        }

        @Override
        public String getShortName() {
            return "precision-at-k";
        }
    }
}

