/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.outlier;

import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.DatabaseUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.geometry.XYCurve;
import de.lmu.ifi.dbs.elki.result.EvaluationResult;
import de.lmu.ifi.dbs.elki.result.OrderingResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import java.util.List;
import java.util.regex.Pattern;

public class OutlierPrecisionRecallCurve
implements Evaluator {
    public static final String PRAUC_LABEL = "PR AUC";
    private static final Logging LOG = Logging.getLogger(OutlierPrecisionRecallCurve.class);
    private Pattern positiveClassName;

    public OutlierPrecisionRecallCurve(Pattern positiveClassName) {
        this.positiveClassName = positiveClassName;
    }

    @Override
    public void processNewResult(ResultHierarchy hier, Result result) {
        EvaluationResult ev;
        PRCurve curve;
        ArrayModifiableDBIDs sorted;
        Database db = ResultUtil.findDatabase(hier);
        SetDBIDs positiveids = DBIDUtil.ensureSet(DatabaseUtil.getObjectsByLabelMatch(db, this.positiveClassName));
        if (positiveids.size() == 0) {
            LOG.warning("Computing a P/R curve failed - no objects matched.");
            return;
        }
        List<OutlierResult> oresults = OutlierResult.getOutlierResults(result);
        List<OrderingResult> orderings = ResultUtil.getOrderingResults(result);
        for (OutlierResult o : oresults) {
            sorted = o.getOrdering().order(o.getOrdering().getDBIDs());
            curve = this.computePrecisionResult(positiveids, sorted.iter(), o.getScores());
            db.getHierarchy().add(o, curve);
            ev = EvaluationResult.findOrCreate(db.getHierarchy(), o, "Evaluation of ranking", "ranking-evaluation");
            ev.findOrCreateGroup("Evaluation measures").addMeasure(PRAUC_LABEL, curve.getAUC(), 0.0, 1.0, false);
            orderings.remove(o.getOrdering());
        }
        for (OrderingResult or : orderings) {
            sorted = or.order(or.getDBIDs());
            curve = this.computePrecisionResult(positiveids, sorted.iter(), null);
            db.getHierarchy().add(or, curve);
            ev = EvaluationResult.findOrCreate(db.getHierarchy(), or, "Evaluation of ranking", "ranking-evaluation");
            ev.findOrCreateGroup("Evaluation measures").addMeasure(PRAUC_LABEL, curve.getAUC(), 0.0, 1.0, false);
        }
    }

    private PRCurve computePrecisionResult(SetDBIDs ids, DBIDIter iter, DoubleRelation scores) {
        int postot = ids.size();
        int poscnt = 0;
        int total = 0;
        PRCurve curve = new PRCurve(postot + 2, postot);
        double prevscore = Double.NaN;
        while (iter.valid()) {
            block5: {
                double curreca;
                double curprec;
                block6: {
                    curprec = (double)poscnt / (double)total;
                    curreca = (double)poscnt / (double)postot;
                    if (ids.contains(iter)) {
                        ++poscnt;
                    }
                    if (++total == 1) break block5;
                    if (scores == null) break block6;
                    double curscore = scores.doubleValue(iter);
                    if (Double.compare(prevscore, curscore) == 0) break block5;
                    prevscore = curscore;
                }
                curve.addAndSimplify(curreca, curprec);
            }
            iter.advance();
        }
        curve.addAndSimplify(1.0, postot / total);
        return curve;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID POSITIVE_CLASS_NAME_ID = new OptionID("precision.positive", "Class label for the 'positive' class.");
        protected Pattern positiveClassName = null;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            PatternParameter positiveClassNameP = new PatternParameter(POSITIVE_CLASS_NAME_ID);
            if (config.grab(positiveClassNameP)) {
                this.positiveClassName = (Pattern)positiveClassNameP.getValue();
            }
        }

        @Override
        protected OutlierPrecisionRecallCurve makeInstance() {
            return new OutlierPrecisionRecallCurve(this.positiveClassName);
        }
    }

    public static class PRCurve
    extends XYCurve {
        double auc = Double.NaN;
        int positive;

        public PRCurve(int size, int positive) {
            super("Recall", "Precision", size);
            this.positive = positive;
        }

        @Override
        public String getLongName() {
            return "Precision-Recall-Curve";
        }

        @Override
        public String getShortName() {
            return "pr-curve";
        }

        public double getAUC() {
            if (Double.isNaN(this.auc)) {
                double max = 1.0 - 1.0 / (double)this.positive;
                this.auc = PRCurve.areaUnderCurve(this) / max;
            }
            return this.auc;
        }
    }
}

