/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.outlier;

import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.DatabaseUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.evaluation.scores.ROCEvaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.DBIDsTest;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.OutlierScoreAdapter;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.SimpleAdapter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.geometry.XYCurve;
import de.lmu.ifi.dbs.elki.result.EvaluationResult;
import de.lmu.ifi.dbs.elki.result.OrderingResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import java.util.List;
import java.util.regex.Pattern;

@Alias(value={"de.lmu.ifi.dbs.elki.evaluation.roc.ComputeROCCurve", "de.lmu.ifi.dbs.elki.evaluation.ComputeROCCurve"})
public class OutlierROCCurve
implements Evaluator {
    public static final String ROCAUC_LABEL = "ROC AUC";
    private static final Logging LOG = Logging.getLogger(OutlierROCCurve.class);
    private Pattern positiveClassName;

    public OutlierROCCurve(Pattern positive_class_name) {
        this.positiveClassName = positive_class_name;
    }

    private ROCResult computeROCResult(SetDBIDs positiveids, DBIDs order) {
        XYCurve roccurve = ROCEvaluation.materializeROC(new DBIDsTest(positiveids), new SimpleAdapter(order.iter()));
        double rocauc = XYCurve.areaUnderCurve(roccurve);
        return new ROCResult(roccurve, rocauc);
    }

    private ROCResult computeROCResult(SetDBIDs positiveids, OutlierResult or) {
        XYCurve roccurve = ROCEvaluation.materializeROC(new DBIDsTest(positiveids), new OutlierScoreAdapter(or));
        double rocauc = XYCurve.areaUnderCurve(roccurve);
        return new ROCResult(roccurve, rocauc);
    }

    @Override
    public void processNewResult(ResultHierarchy hier, Result result) {
        Database db = ResultUtil.findDatabase(hier);
        SetDBIDs positiveids = DBIDUtil.ensureSet(DatabaseUtil.getObjectsByLabelMatch(db, this.positiveClassName));
        if (positiveids.size() == 0) {
            LOG.warning("Computing a ROC curve failed - no objects matched.");
            return;
        }
        boolean nonefound = true;
        List<OutlierResult> oresults = OutlierResult.getOutlierResults(result);
        List<OrderingResult> orderings = ResultUtil.getOrderingResults(result);
        for (OutlierResult o : oresults) {
            ROCResult rocres = this.computeROCResult(positiveids, o);
            db.getHierarchy().add(o, rocres);
            EvaluationResult ev = EvaluationResult.findOrCreate(db.getHierarchy(), o, "Evaluation of ranking", "ranking-evaluation");
            EvaluationResult.MeasurementGroup g = ev.findOrCreateGroup("Evaluation measures");
            if (!g.hasMeasure(ROCAUC_LABEL)) {
                g.addMeasure(ROCAUC_LABEL, rocres.auc, 0.0, 1.0, false);
            }
            orderings.remove(o.getOrdering());
            nonefound = false;
        }
        for (OrderingResult or : orderings) {
            ArrayModifiableDBIDs sorted = or.order(or.getDBIDs());
            if (sorted.size() != or.getDBIDs().size()) {
                throw new IllegalStateException("Iterable result doesn't match database size - incomplete ordering?");
            }
            ROCResult rocres = this.computeROCResult(positiveids, sorted);
            db.getHierarchy().add(or, rocres);
            EvaluationResult ev = EvaluationResult.findOrCreate(db.getHierarchy(), or, "Evaluation of ranking", "ranking-evaluation");
            EvaluationResult.MeasurementGroup g = ev.findOrCreateGroup("Evaluation measures");
            if (!g.hasMeasure(ROCAUC_LABEL)) {
                g.addMeasure(ROCAUC_LABEL, rocres.auc, 0.0, 1.0, false);
            }
            nonefound = false;
        }
        if (nonefound) {
            return;
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID POSITIVE_CLASS_NAME_ID = new OptionID("rocauc.positive", "Class label for the 'positive' class.");
        protected Pattern positiveClassName = null;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            PatternParameter positiveClassNameP = new PatternParameter(POSITIVE_CLASS_NAME_ID);
            if (config.grab(positiveClassNameP)) {
                this.positiveClassName = (Pattern)positiveClassNameP.getValue();
            }
        }

        @Override
        protected OutlierROCCurve makeInstance() {
            return new OutlierROCCurve(this.positiveClassName);
        }
    }

    public static class ROCResult
    extends XYCurve {
        private double auc;

        public ROCResult(XYCurve col, double rocauc) {
            super(col);
            this.auc = rocauc;
        }

        public double getAUC() {
            return this.auc;
        }

        @Override
        public String getLongName() {
            return "ROC Curve";
        }

        @Override
        public String getShortName() {
            return "roc-curve";
        }
    }
}

