/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.outlier;

import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.DatabaseUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.evaluation.scores.AveragePrecisionEvaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.DCGEvaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.MaximumF1Evaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.NDCGEvaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.PrecisionAtKEvaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.ROCEvaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.DBIDsTest;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.OutlierScoreAdapter;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.SimpleAdapter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.result.EvaluationResult;
import de.lmu.ifi.dbs.elki.result.OrderingResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import java.util.List;
import java.util.regex.Pattern;

public class OutlierRankingEvaluation
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(OutlierRankingEvaluation.class);
    private Pattern positiveClassName;
    private String key = OutlierRankingEvaluation.class.getName();

    public OutlierRankingEvaluation(Pattern positive_class_name) {
        this.positiveClassName = positive_class_name;
    }

    private EvaluationResult evaluateOutlierResult(int size, SetDBIDs positiveids, OutlierResult or) {
        EvaluationResult res = EvaluationResult.findOrCreate(or.getHierarchy(), or, "Evaluation of ranking", "ranking-evaluation");
        DBIDsTest test = new DBIDsTest(positiveids);
        int pos = positiveids.size();
        double rate = (double)pos / (double)size;
        EvaluationResult.MeasurementGroup g = res.findOrCreateGroup("Evaluation measures");
        double rocauc = ROCEvaluation.STATIC.evaluate(test, new OutlierScoreAdapter(or));
        if (!g.hasMeasure("ROC AUC")) {
            g.addMeasure("ROC AUC", rocauc, 0.0, 1.0, 0.5, false);
        }
        double avep = AveragePrecisionEvaluation.STATIC.evaluate(test, new OutlierScoreAdapter(or));
        g.addMeasure("Average Precision", avep, 0.0, 1.0, rate, false);
        double rprec = PrecisionAtKEvaluation.RPRECISION.evaluate(test, new OutlierScoreAdapter(or));
        g.addMeasure("R-Precision", rprec, 0.0, 1.0, rate, false);
        double maxf1 = MaximumF1Evaluation.STATIC.evaluate(test, new OutlierScoreAdapter(or));
        g.addMeasure("Maximum F1", maxf1, 0.0, 1.0, rate, false);
        double maxdcg = DCGEvaluation.maximum(pos);
        double dcg = DCGEvaluation.STATIC.evaluate(test, new OutlierScoreAdapter(or));
        g.addMeasure("DCG", dcg, 0.0, maxdcg, DCGEvaluation.STATIC.expected(pos, size), false);
        double ndcg = NDCGEvaluation.STATIC.evaluate(test, new OutlierScoreAdapter(or));
        g.addMeasure("NDCG", ndcg, 0.0, 1.0, NDCGEvaluation.STATIC.expected(pos, size), false);
        g = res.findOrCreateGroup("Adjusted for chance");
        double adjauc = 2.0 * rocauc - 1.0;
        g.addMeasure("Adjusted AUC", adjauc, 0.0, 1.0, 0.0, false);
        double adjavep = (avep - rate) / (1.0 - rate);
        g.addMeasure("Adjusted AveP", adjavep, 0.0, 1.0, 0.0, false);
        double adjrprec = (rprec - rate) / (1.0 - rate);
        g.addMeasure("Adjusted R-Prec", adjrprec, 0.0, 1.0, 0.0, false);
        double adjmaxf1 = (maxf1 - rate) / (1.0 - rate);
        g.addMeasure("Adjusted Max F1", adjmaxf1, 0.0, 1.0, 0.0, false);
        double endcg = NDCGEvaluation.STATIC.expected(pos, size);
        double adjndcg = (ndcg - endcg) / (1.0 - endcg);
        g.addMeasure("Adjusted DCG", adjndcg, 0.0, 1.0, 0.0, false);
        if (LOG.isStatistics()) {
            LOG.statistics(new DoubleStatistic(this.key + ".rocauc", rocauc));
            LOG.statistics(new DoubleStatistic(this.key + ".rocauc.adjusted", adjauc));
            LOG.statistics(new DoubleStatistic(this.key + ".precision.average", avep));
            LOG.statistics(new DoubleStatistic(this.key + ".precision.average.adjusted", adjavep));
            LOG.statistics(new DoubleStatistic(this.key + ".precision.r", rprec));
            LOG.statistics(new DoubleStatistic(this.key + ".precision.r.adjusted", adjrprec));
            LOG.statistics(new DoubleStatistic(this.key + ".f1.maximum", maxf1));
            LOG.statistics(new DoubleStatistic(this.key + ".f1.maximum.adjusted", adjmaxf1));
            LOG.statistics(new DoubleStatistic(this.key + ".dcg", dcg));
            LOG.statistics(new DoubleStatistic(this.key + ".dcg.normalized", ndcg));
            LOG.statistics(new DoubleStatistic(this.key + ".dcg.adjusted", adjndcg));
        }
        return res;
    }

    private EvaluationResult evaluateOrderingResult(int size, SetDBIDs positiveids, DBIDs order) {
        if (order.size() != size) {
            throw new IllegalStateException("Iterable result doesn't match database size - incomplete ordering?");
        }
        EvaluationResult res = new EvaluationResult("Evaluation of ranking", "ranking-evaluation");
        DBIDsTest test = new DBIDsTest(positiveids);
        double rate = (double)positiveids.size() / (double)size;
        EvaluationResult.MeasurementGroup g = res.newGroup("Evaluation measures:");
        double rocauc = ROCEvaluation.STATIC.evaluate(test, new SimpleAdapter(order.iter()));
        g.addMeasure("ROC AUC", rocauc, 0.0, 1.0, 0.5, false);
        double avep = AveragePrecisionEvaluation.STATIC.evaluate(test, new SimpleAdapter(order.iter()));
        g.addMeasure("Average Precision", avep, 0.0, 1.0, rate, false);
        double rprec = PrecisionAtKEvaluation.RPRECISION.evaluate(test, new SimpleAdapter(order.iter()));
        g.addMeasure("R-Precision", rprec, 0.0, 1.0, rate, false);
        double maxf1 = MaximumF1Evaluation.STATIC.evaluate(test, new SimpleAdapter(order.iter()));
        g.addMeasure("Maximum F1", maxf1, 0.0, 1.0, rate, false);
        g = res.newGroup("Adjusted for chance:");
        double adjauc = 2.0 * rocauc - 1.0;
        g.addMeasure("Adjusted AUC", adjauc, 0.0, 1.0, 0.0, false);
        double adjavep = (avep - rate) / (1.0 - rate);
        g.addMeasure("Adjusted AveP", adjavep, 0.0, 1.0, 0.0, false);
        double adjrprec = (rprec - rate) / (1.0 - rate);
        g.addMeasure("Adjusted R-Prec", adjrprec, 0.0, 1.0, 0.0, false);
        double adjmaxf1 = (maxf1 - rate) / (1.0 - rate);
        g.addMeasure("Adjusted Max F1", adjmaxf1, 0.0, 1.0, 0.0, false);
        if (LOG.isStatistics()) {
            LOG.statistics(new DoubleStatistic(this.key + ".rocauc", rocauc));
            LOG.statistics(new DoubleStatistic(this.key + ".rocauc.adjusted", adjauc));
            LOG.statistics(new DoubleStatistic(this.key + ".precision.average", avep));
            LOG.statistics(new DoubleStatistic(this.key + ".precision.average.adjusted", adjavep));
            LOG.statistics(new DoubleStatistic(this.key + ".precision.r", rprec));
            LOG.statistics(new DoubleStatistic(this.key + ".precision.r.adjusted", adjrprec));
            LOG.statistics(new DoubleStatistic(this.key + ".f1.maximum", maxf1));
            LOG.statistics(new DoubleStatistic(this.key + ".f1.maximum.adjusted", adjmaxf1));
        }
        return res;
    }

    @Override
    public void processNewResult(ResultHierarchy hier, Result result) {
        Database db = ResultUtil.findDatabase(hier);
        SetDBIDs positiveids = DBIDUtil.ensureSet(DatabaseUtil.getObjectsByLabelMatch(db, this.positiveClassName));
        if (positiveids.size() == 0) {
            LOG.warning("Cannot evaluate outlier results - no objects matched the given pattern.");
            return;
        }
        boolean nonefound = true;
        List<OutlierResult> oresults = OutlierResult.getOutlierResults(result);
        List<OrderingResult> orderings = ResultUtil.getOrderingResults(result);
        for (OutlierResult o : oresults) {
            db.getHierarchy().add(o, this.evaluateOutlierResult(o.getScores().size(), positiveids, o));
            orderings.remove(o.getOrdering());
            nonefound = false;
        }
        for (OrderingResult or : orderings) {
            ArrayModifiableDBIDs sorted = or.order(or.getDBIDs());
            db.getHierarchy().add(or, this.evaluateOrderingResult(or.getDBIDs().size(), positiveids, sorted));
            nonefound = false;
        }
        if (nonefound) {
            return;
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID POSITIVE_CLASS_NAME_ID = new OptionID("outliereval.positive", "Class label for the 'positive' class.");
        protected Pattern positiveClassName = null;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            PatternParameter positiveClassNameP = new PatternParameter(POSITIVE_CLASS_NAME_ID);
            if (config.grab(positiveClassNameP)) {
                this.positiveClassName = (Pattern)positiveClassNameP.getValue();
            }
        }

        @Override
        protected OutlierRankingEvaluation makeInstance() {
            return new OutlierRankingEvaluation(this.positiveClassName);
        }
    }
}

