/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.outlier;

import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.DatabaseUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.evaluation.outlier.OutlierROCCurve;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.geometry.XYCurve;
import de.lmu.ifi.dbs.elki.result.OrderingResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import java.util.List;
import java.util.regex.Pattern;

@Reference(authors="W. Klement, P. A. Flach, N. Japkowicz, S. Matwin", title="Smooth Receiver Operating Characteristics (smROC) Curves", booktitle="European Conf. Machine Learning and Principles and Practice of Knowledge Discovery in Databases (ECML-PKDD'11)", url="https://doi.org/10.1007/978-3-642-23783-6_13", bibkey="DBLP:conf/pkdd/KlementFJM11")
public class OutlierSmROCCurve
implements Evaluator {
    public static final String SMROCAUC_LABEL = "ROCAUC";
    private static final Logging LOG = Logging.getLogger(OutlierSmROCCurve.class);
    private Pattern positiveClassName;

    public OutlierSmROCCurve(Pattern positive_class_name) {
        this.positiveClassName = positive_class_name;
    }

    private SmROCResult computeSmROCResult(SetDBIDs positiveids, OutlierResult or) {
        DoubleRelation scores = or.getScores();
        int size = scores.size();
        double mean = 0.0;
        DBIDIter iditer = scores.iterDBIDs();
        while (iditer.valid()) {
            mean += scores.doubleValue(iditer) / (double)size;
            iditer.advance();
        }
        SmROCResult curve = new SmROCResult(positiveids.size() + 2);
        curve.add(0.0, 0.0);
        int poscnt = 0;
        int negcnt = 0;
        double prevscore = Double.NaN;
        double x = 0.0;
        double y = 0.0;
        DBIDArrayMIter nei = or.getOrdering().order(or.getOrdering().getDBIDs()).iter();
        while (nei.valid()) {
            double curscore = scores.doubleValue(nei);
            if (!Double.isNaN(prevscore) && Double.compare(prevscore, curscore) == 0) {
                if (positiveids.contains(nei)) {
                    ++poscnt;
                } else {
                    ++negcnt;
                }
            } else {
                if (prevscore > mean) {
                    y += (double)poscnt * prevscore + (double)negcnt * (1.0 - prevscore);
                    x += (double)poscnt * (1.0 - prevscore) + (double)negcnt * prevscore;
                } else if (prevscore < mean) {
                    y += (double)poscnt * (1.0 - prevscore) + (double)negcnt * prevscore;
                    x += (double)poscnt * prevscore + (double)negcnt * (1.0 - prevscore);
                }
                curve.addAndSimplify(x, y);
                if (positiveids.contains(nei)) {
                    poscnt = 1;
                    negcnt = 0;
                } else {
                    poscnt = 0;
                    negcnt = 1;
                }
                prevscore = curscore;
            }
            nei.advance();
        }
        if (prevscore > mean) {
            y += (double)poscnt * prevscore + (double)negcnt * (1.0 - prevscore);
            x += (double)poscnt * (1.0 - prevscore) + (double)negcnt * prevscore;
        } else if (prevscore < mean) {
            y += (double)poscnt * (1.0 - prevscore) + (double)negcnt * prevscore;
            x += (double)poscnt * prevscore + (double)negcnt * (1.0 - prevscore);
        }
        curve.addAndSimplify(x, y);
        double rocauc = XYCurve.areaUnderCurve(curve) / (x * y);
        if (LOG.isVerbose()) {
            LOG.verbose("ROCAUC: " + rocauc);
        }
        curve.rocauc = rocauc;
        return curve;
    }

    @Override
    public void processNewResult(ResultHierarchy hier, Result result) {
        Database db = ResultUtil.findDatabase(hier);
        SetDBIDs positiveids = DBIDUtil.ensureSet(DatabaseUtil.getObjectsByLabelMatch(db, this.positiveClassName));
        if (positiveids.size() == 0) {
            LOG.warning("Computing a ROC curve failed - no objects matched.");
            return;
        }
        List<OutlierResult> oresults = OutlierResult.getOutlierResults(result);
        List<OrderingResult> orderings = ResultUtil.getOrderingResults(result);
        for (OutlierResult o : oresults) {
            db.getHierarchy().add(o, this.computeSmROCResult(positiveids, o));
            orderings.remove(o.getOrdering());
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected Pattern positiveClassName = null;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            PatternParameter positiveClassNameP = new PatternParameter(OutlierROCCurve.Parameterizer.POSITIVE_CLASS_NAME_ID);
            if (config.grab(positiveClassNameP)) {
                this.positiveClassName = (Pattern)positiveClassNameP.getValue();
            }
        }

        @Override
        protected OutlierSmROCCurve makeInstance() {
            return new OutlierSmROCCurve(this.positiveClassName);
        }
    }

    public static class SmROCResult
    extends XYCurve {
        double rocauc = Double.NaN;

        public SmROCResult(int size) {
            super("SmROC Negative", "SmROC Positive", size);
        }

        @Override
        public String getLongName() {
            return "SmROC Curve";
        }

        @Override
        public String getShortName() {
            return "smroc-curve";
        }

        public double getAUC() {
            return this.rocauc;
        }
    }
}

