/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.outlier;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleListParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.IdentityScaling;
import de.lmu.ifi.dbs.elki.utilities.scaling.ScalingFunction;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScaling;
import java.util.ArrayList;
import java.util.Arrays;

public class OutlierThresholdClustering
implements Evaluator {
    ScalingFunction scaling = null;
    double[] threshold;

    public OutlierThresholdClustering(ScalingFunction scaling, double[] threshold) {
        this.scaling = scaling;
        this.threshold = threshold;
        Arrays.sort(this.threshold);
    }

    @Override
    public void processNewResult(ResultHierarchy hier, Result newResult) {
        ArrayList<OutlierResult> ors = ResultUtil.filterResults(hier, newResult, OutlierResult.class);
        for (OutlierResult or : ors) {
            hier.add(or, this.split(or));
        }
    }

    private Clustering<Model> split(OutlierResult or) {
        DoubleRelation scores = or.getScores();
        if (this.scaling instanceof OutlierScaling) {
            ((OutlierScaling)this.scaling).prepare(or);
        }
        ArrayList<HashSetModifiableDBIDs> idlists = new ArrayList<HashSetModifiableDBIDs>(this.threshold.length + 1);
        for (int i = 0; i <= this.threshold.length; ++i) {
            idlists.add(DBIDUtil.newHashSet());
        }
        DBIDIter iter = scores.getDBIDs().iter();
        while (iter.valid()) {
            int i;
            double score = scores.doubleValue(iter);
            if (this.scaling != null) {
                score = this.scaling.getScaled(score);
            }
            for (i = 0; i < this.threshold.length && !(score < this.threshold[i]); ++i) {
            }
            ((ModifiableDBIDs)idlists.get(i)).add(iter);
            iter.advance();
        }
        Clustering<Model> c = new Clustering<Model>("Outlier threshold clustering", "threshold-clustering");
        for (int i = 0; i <= this.threshold.length; ++i) {
            String name = i == 0 ? "Inlier" : "Outlier_" + this.threshold[i - 1];
            c.addToplevelCluster(new Cluster(name, (DBIDs)idlists.get(i), i > 0));
        }
        return c;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID SCALING_ID = new OptionID("thresholdclust.scaling", "Class to use as scaling function.");
        public static final OptionID THRESHOLD_ID = new OptionID("thresholdclust.threshold", "Threshold(s) to apply.");
        ScalingFunction scaling = null;
        double[] threshold;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleListParameter thresholdP;
            super.makeOptions(config);
            ObjectParameter scalingP = new ObjectParameter(SCALING_ID, (Class<?>)ScalingFunction.class, IdentityScaling.class);
            if (config.grab(scalingP)) {
                this.scaling = (ScalingFunction)scalingP.instantiateClass(config);
            }
            if (config.grab(thresholdP = new DoubleListParameter(THRESHOLD_ID))) {
                this.threshold = (double[])((double[])thresholdP.getValue()).clone();
            }
        }

        @Override
        protected OutlierThresholdClustering makeInstance() {
            return new OutlierThresholdClustering(this.scaling, this.threshold);
        }
    }
}

