/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.scores;

import de.lmu.ifi.dbs.elki.evaluation.scores.ScoreEvaluation;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class AveragePrecisionEvaluation
implements ScoreEvaluation {
    public static final AveragePrecisionEvaluation STATIC = new AveragePrecisionEvaluation();

    @Override
    public <I extends ScoreEvaluation.ScoreIter> double evaluate(ScoreEvaluation.Predicate<? super I> predicate, I iter) {
        int poscnt = 0;
        int negcnt = 0;
        int pospre = 0;
        double acc = 0.0;
        while (iter.valid()) {
            do {
                if (predicate.test(iter)) {
                    ++poscnt;
                } else {
                    ++negcnt;
                }
                iter.advance();
            } while (iter.valid() && iter.tiedToPrevious());
            if (poscnt <= pospre) continue;
            acc += (double)poscnt / (double)(poscnt + negcnt) * (double)(poscnt - pospre);
            pospre = poscnt;
        }
        return poscnt > 0 ? acc / (double)poscnt : 0.0;
    }

    @Override
    public double expected(int pos, int all) {
        return (double)pos / (double)all;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected AveragePrecisionEvaluation makeInstance() {
            return STATIC;
        }
    }
}

