/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.scores;

import de.lmu.ifi.dbs.elki.evaluation.scores.ScoreEvaluation;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

@Reference(authors="K. J\u00e4rvelin, J. Kek\u00e4l\u00e4inen", title="Cumulated gain-based evaluation of IR techniques", booktitle="ACM Transactions on Information Systems (TOIS)", url="https://doi.org/10.1145/582415.582418", bibkey="DBLP:journals/tois/JarvelinK02")
public class DCGEvaluation
implements ScoreEvaluation {
    public static final DCGEvaluation STATIC = new DCGEvaluation();

    @Override
    public <I extends ScoreEvaluation.ScoreIter> double evaluate(ScoreEvaluation.Predicate<? super I> predicate, I iter) {
        return DCGEvaluation.computeDCG(predicate, iter);
    }

    @Override
    public double expected(int pos, int all) {
        return DCGEvaluation.sumInvLog1p(1, all) * (double)pos / (double)all * MathUtil.LOG2;
    }

    public static double sumInvLog1p(int s, int e) {
        double sum = 0.0;
        for (int i = e + 1; i > s; --i) {
            sum += 1.0 / FastMath.log(i);
        }
        return sum;
    }

    public static <I extends ScoreEvaluation.ScoreIter> double computeDCG(ScoreEvaluation.Predicate<? super I> predicate, I iter) {
        double sum = 0.0;
        int i = 0;
        int positive = 0;
        int tied = 0;
        while (iter.valid()) {
            do {
                if (predicate.test(iter)) {
                    ++positive;
                }
                ++tied;
                ++i;
                iter.advance();
            } while (iter.valid() && iter.tiedToPrevious());
            if (positive > 0) {
                sum += tied == 1 ? 1.0 / FastMath.log(i + 1) : DCGEvaluation.sumInvLog1p(i - tied + 1, i) * (double)positive / (double)tied;
            }
            positive = 0;
            tied = 0;
        }
        return sum * MathUtil.LOG2;
    }

    public static double maximum(int pos) {
        return DCGEvaluation.sumInvLog1p(1, pos) * MathUtil.LOG2;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected DCGEvaluation makeInstance() {
            return STATIC;
        }
    }
}

