/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.scores;

import de.lmu.ifi.dbs.elki.evaluation.scores.ScoreEvaluation;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class MaximumF1Evaluation
implements ScoreEvaluation {
    public static final MaximumF1Evaluation STATIC = new MaximumF1Evaluation();

    @Override
    public <I extends ScoreEvaluation.ScoreIter> double evaluate(ScoreEvaluation.Predicate<? super I> predicate, I iter) {
        int postot = predicate.numPositive();
        int poscnt = 0;
        int cnt = 0;
        double maxf1 = 0.0;
        while (iter.valid()) {
            do {
                if (predicate.test(iter)) {
                    ++poscnt;
                }
                ++cnt;
                iter.advance();
            } while (iter.valid() && iter.tiedToPrevious());
            double p = (double)poscnt / (double)cnt;
            double r = (double)poscnt / (double)postot;
            double f1 = 2.0 * p * r / (p + r);
            if (!(f1 > maxf1)) continue;
            maxf1 = f1;
        }
        return maxf1;
    }

    @Override
    public double expected(int pos, int all) {
        return (double)pos / (double)all;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected MaximumF1Evaluation makeInstance() {
            return STATIC;
        }
    }
}

